% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sperrorest_resampling.R
\name{represampling_bootstrap}
\alias{represampling_bootstrap}
\title{Non-spatial bootstrap resampling}
\usage{
represampling_bootstrap(data, coords = c("x", "y"), nboot = nrow(data),
  repetition = 1, seed1 = NULL, oob = FALSE)
}
\arguments{
\item{data}{\code{data.frame} containing at least the columns specified
by \code{coords}}

\item{coords}{vector of length 2 defining the variables in \code{data} that
contain the x and y coordinates of sample locations.}

\item{nboot}{Size of bootstrap sample}

\item{repetition}{numeric vector: cross-validation repetitions
to be generated. Note that this is not the number of repetitions,
but the indices of these repetitions. E.g., use \code{repetition = c(1:100)}
to obtain (the 'first') 100 repetitions, and \code{repetition = c(101:200)}
to obtain a different set of 100 repetitions.}

\item{seed1}{\code{seed1+i} is the random seed that will be used by
\link{set.seed} in repetition \code{i} (\code{i} in \code{repetition})
to initialize the random number generator before sampling from the data set.}

\item{oob}{logical (default \code{FALSE}): if \code{TRUE}, use the out-of-bag
sample as the test sample; if \code{FALSE}, draw a second bootstrap sample of
size \code{nboot} independently to obtain a test sample.}
}
\value{
A \link{represampling} object. This is a (named) list
containing \code{length(repetition)}.
\link{resampling} objects. Each of these contains only one list with
indices of \code{train}ing and \code{test} samples.
Indices are row indices for \code{data}.
}
\description{
\code{represampling_bootstrap} draws a bootstrap random sample
(with replacement) from \code{data}.
}
\examples{
data(ecuador)
# only 10 bootstrap repetitions, normally use >=100:
parti <- represampling_bootstrap(ecuador, repetition = 10)
# plot(parti, ecuador) # careful: overplotting occurs
# because some samples are included in both the training and
# the test sample (possibly even multiple times)
}
