% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MI.vec.R
\name{MI.vec}
\alias{MI.vec}
\title{Moran Test for Spatial Autocorrelation}
\usage{
MI.vec(x, W, alternative = "greater", symmetrize = TRUE)
}
\arguments{
\item{x}{a vector or matrix}

\item{W}{spatial connectivity matrix}

\item{alternative}{specification of alternative hypothesis as 'greater' (default),
'lower', or 'two.sided'}

\item{symmetrize}{symmetrizes the connectivity matrix \emph{\strong{W}}
by: 1/2 * (\emph{\strong{W}} + \emph{\strong{W}}') (TRUE/ FALSE).}
}
\value{
Returns an object of class \code{data.frame} that contains the
following information for each variable:
\describe{
\item{\code{I}}{observed value of the Moran coefficient}
\item{\code{EI}}{expected value of Moran's I}
\item{\code{VarI}}{variance of Moran's I (under normality)}
\item{\code{zI}}{standardized Moran coefficient}
\item{\code{pI}}{\emph{p}-value of the test statistic}
}
}
\description{
Tests for the presence of spatial autocorrelation
in variables as indicated by the Moran coefficient. The variance
is calculated under the normality assumption.
}
\details{
If \code{x} is a matrix, this function computes the Moran
test for spatial autocorrelation for each column.
}
\note{
Estimation of the variance (under the normality assumption)
follows Cliff and Ord (1981), see also Upton and Fingleton (1985).
It assumes the connectivity matrix \emph{\strong{W}} to be symmetric.
For inherently non-symmetric matrices, it is recommended to specify
\code{symmetrize=TRUE}.
}
\examples{
data(fakedata)
X <- cbind(fakedataset$x1,fakedataset$x2,fakedataset$x3)

MI <- MI.vec(x=X,W=W,alternative="greater",symmetrize=TRUE)
MI

}
\references{
Cliff, Andrew D. and John K. Ord (1981): Spatial Processes:
Models & Applications. Pion, London.

Upton, Graham J. G. and Bernard Fingleton (1985): Spatial Data Analysis
by Example, Volume 1. New York, Wiley.

Bivand, Roger S. and David W. S. Wong (2018): Comparing Implementations
of Global and Local Indicators of Spatial Association. TEST 27:
pp. 716 - 748.
}
\seealso{
\code{\link{MI.resid}}
}
\author{
Sebastian Juhl
}
