% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getEVs.R
\name{getEVs}
\alias{getEVs}
\title{Eigenfunction Decomposition of a (Transformed) Spatial Connectivity
Matrix}
\usage{
getEVs(W, covars = NULL)
}
\arguments{
\item{W}{spatial connectivity matrix}

\item{covars}{vector/ matrix of regressors included in the construction
of the projection matrix \emph{\strong{M}} - see Details}
}
\value{
A list containing the following objects:
\describe{
\item{\code{vectors}}{matrix of all eigenvectors}
\item{\code{values}}{vector of the corresponding eigenvalues}
\item{\code{moran}}{vector of the Moran coefficients associated with
the eigenvectors}
}
}
\description{
Extract eigenvectors and corresponding eigenvalues from
the matrix \emph{\strong{MWM}}, where \emph{\strong{M}} denotes a symmetric
and idempotent projection matrix and \emph{\strong{W}} is the spatial
connectivity matrix. This function also reports the Moran coefficient
associated with each of the eigenvectors.
}
\details{
The eigenfunctions obtained by \code{getEVs}
can be used to perform supervised eigenvector selection and to
manually create a spatial filter. To this end, a candidate set
may be determined by 1) the sign of the spatial autocorrelation
in model residuals and 2) the strength of spatial association
found in each eigenvector as indicated by \code{moran}.

Prior to the spectral decomposition, \code{getEVs} symmetrizes the
spatial connectivity matrix by: 1/2 * (\emph{\strong{W}} + \emph{\strong{W}}').

If \code{covars} are supplied, the function uses the covariates to construct
projection matrix: \emph{\strong{M} = \strong{I} - \strong{X} (\strong{X}'
\strong{X})^-1\strong{X}'}. Using this matrix results in a set of
eigenvectors that are uncorrelated to each other as well as to the
covariates. If \code{covars=NULL}, only the intercept term is used
to construct \emph{\strong{M}}. See e.g., Griffith and Tiefelsdorf (2007)
for more details on the appropriate choice of \emph{\strong{M}}.
}
\examples{
data(fakedata)

E <-getEVs(W=W,covars=NULL)

}
\references{
Tiefelsdorf, Michael and Daniel A. Griffith (2007):
Semiparametric filtering of spatial autocorrelation: the eigenvector
approach. Environment and Planning A: Economy and Space, 39 (5):
pp. 1193 - 1221.
}
\seealso{
\code{\link{lmFilter}}, \code{\link{glmFilter}}, \code{\link{MI.ev}},
\code{\link{MI.sf}}, \code{\link{vif.ev}}, \code{\link{partialR2}}
}
\author{
Sebastian Juhl
}
