% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spidR.R
\name{wst.data}
\alias{wst.data}
\title{Downloads WST data.}
\usage{
wst.data(spp, trait = NULL)
}
\arguments{
\item{spp}{A vector with species names.}

\item{trait}{A vector with required traits as abbreviations. Valid values can be found at: https://spidertraits.sci.muni.cz/traits}
}
\value{
A matrix with trait data.
}
\description{
Downloads the most recent data from the World Spider Trait database.
}
\details{
The World Spider Trait database (Pekar et al. 2021) has been designed to contain trait data in a broad sense, from morphological traits to ecological characteristics, ecophysiology, behavioural habits, and more (Lowe et al. 2020). This function will download everything available for the species given.
}
\examples{
\dontrun{
wst.data("Atypus affinis")
wst.data("Zodarion costapratae", trait = "bole")
wst.data(c("Iberesia machadoi", "Zodarion costapratae"))
wst.data(c("Iberesia machadoi", "Zodarion costapratae"), trait = c("balo", "bole"))
}
}
\references{
Lowe, E., Wolff, J.O., Aceves-Aparicio, A., Birkhofer, K., Branco, V.V., Cardoso, P., Chichorro, F., Fukushima, C.S., Goncalves-Souza, T., Haddad, C.R., Isaia, M., Krehenwinkel, H., Audisio, T.L., Macias-Hernandez, N., Malumbres-Olarte, J., Mammola, S., McLean, D.J., Michalko, R., Nentwig, W., Pekar, S., Petillon, J., Privet, K., Scott, C., Uhl, G., Urbano-Tenorio, F., Wong, B.H. & Herbestein, M.E. (2020). Towards establishment of a centralized spider traits database. Journal of Arachnology, 48: 103-109. https://doi.org/10.1636/0161-8202-48.2.103

Pekar, S., Cernecka, L., Wolff, J., Mammola, S., Cardoso, P., Lowe, E., Fukushima, C.S., Birkhofer, K. & Herberstein, M.E. (2021). The spider trait database. Masaryk University, Brno, URL: https://spidertraits.sci.muni.cz
}
