% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distances.R
\name{distanceToSp}
\alias{distanceToSp}
\title{Collecting distances between input planes and input special plane.}
\usage{
distanceToSp(planes, specialPlane)
}
\arguments{
\item{planes}{Input planes (e.g. result of guided tour)}

\item{specialPlane}{Plane defining the optimal view}
}
\value{
numeric vector containing all distances
}
\description{
If the optimal view is known, we can use the distance between a given plane
and the optimal one as a proxy to diagnose the performance of the guided tour.
}
\examples{
planes <- purrr::rerun(10, tourr::basis_random(5))
specialPlane <- basisMatrix(1,2,5)
d <- distanceToSp(planes, specialPlane)
plot(d)
}
