% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util.r
\name{view_manip_space}
\alias{view_manip_space}
\title{Plot projection frame and return the axes table.}
\usage{
view_manip_space(basis, manip_var, manip_col = "blue", theta = pi *
  5/12, z_col = "red", labels = paste0("V", 1:nrow(basis)))
}
\arguments{
\item{basis}{A (p, d) basis, XY linear combination of each dimension
(numeric variable).}

\item{manip_var}{Number of the column/dimension to rotate.}

\item{manip_col}{String of the color to highlight the \code{manip_var}.}

\item{theta}{Angle in radians to rotate the manip space.
Defaults to pi * 5/12.}

\item{z_col}{Color to illustrate the z direction or out of the projection
plane.}

\item{labels}{Optional, character vector of \code{p} length, add name to the axes
in the reference frame, typically the variable names.}
}
\value{
ggplot object of the basis.
}
\description{
Uses base graphics to plot the circle with axes representing
the projection frame. Returns the corresponding table.
}
\examples{
flea_std <- tourr::rescale(tourr::flea[, 1:6])
rb <- basis_random(ncol(flea_std), 2)

view_manip_space(basis = rb, manip_var = 4)
}
