% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/3_visualize.r
\name{play_tour_path}
\alias{play_tour_path}
\title{Render display of a provided tour path}
\usage{
play_tour_path(
  tour_path,
  data = NULL,
  angle = 0.15,
  render_type = render_plotly,
  rescale_data = FALSE,
  ...
)
}
\arguments{
\item{tour_path}{The result of \code{tourr::save_history()} or \code{manual_tour()}.}

\item{data}{Optional, number of columns must match that of \code{tour_path}.}

\item{angle}{Target distance (in radians) between steps. Defaults to .15.}

\item{render_type}{Graphics to render to. Defaults to render_plotly,
alternative use render_gganimate.}

\item{rescale_data}{When TRUE scales the data to between 0 and 1.
Defaults to FALSE.}

\item{...}{Optionally pass additional arguments to the \code{render_type} for
projection point aesthetics; \code{geom_point(aes(...))}.}
}
\description{
Takes the result of \code{tourr::save_history()} or \code{manual_tour()}, interpolates
over the path and renders into a selected \code{render_type}.
}
\examples{
flea_std <- tourr::rescale(tourr::flea[, 1:6])
tpath <- tourr::save_history(flea_std, tour_path = tourr::grand_tour(), max = 3)
class <- tourr::flea$species

\dontrun{
play_tour_path(tour_path = tpath, data = flea_std)

play_tour_path(tour_path = tpath, data = flea_std, angle = .25, fps = 4,
  render_type = render_gganimate, color = class, shape = class, axes = "bottomleft")
}
}
