% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/marginalEffects.R
\name{effect.bingmm}
\alias{effect.bingmm}
\alias{summary.effect.bingmm}
\alias{print.summary.effect.bingmm}
\title{Estimation of the average marginal effects for SARB model estimated using GMM procedures.}
\usage{
effect.bingmm(
  object,
  vcov = NULL,
  vce = c("robust", "efficient", "ml"),
  het = TRUE,
  atmeans = FALSE,
  type = c("mc", "delta"),
  R = 100,
  approximation = FALSE,
  pw = 5,
  tol = 1e-06,
  empirical = FALSE,
  ...
)

\method{summary}{effect.bingmm}(object, ...)

\method{print}{summary.effect.bingmm}(x, digits = max(3, getOption("digits") - 3), ...)
}
\arguments{
\item{object}{an object of class \code{bingmm}, \code{binlgmm}, or \code{effect.bingmm} for \code{summary} and \code{print} method.}

\item{vcov}{an estimate of the asymptotic variance-covariance matrix of the parameters for a \code{bingmm} or \code{binlgmm} object.}

\item{vce}{string indicating what kind of variance-covariance matrix of the estimate should be computed when using \code{effect.bingmm}. For the one-step GMM estimator, the options are \code{"robust"} and \code{"ml"}. For the two-step GMM estimator, the options are \code{"robust"}, \code{"efficient"} and \code{"ml"}. The option \code{"vce = ml"} is an exploratory method that evaluates the VC of the RIS estimator using the GMM estimates.}

\item{het}{logical. If \code{TRUE} (the default), then the heteroskedasticity is taken into account when computing the average marginal effects.}

\item{atmeans}{logical. If \code{FALSE} (the default), then the average marginal effects are computed at the unit level.}

\item{type}{string indicating which method is used to compute the standard errors of the average marginal effects. If \code{"mc"}, then the Monte Carlo approximation is used. If \code{"delta"}, then the Delta Method is used.}

\item{R}{numerical. Indicates the number of draws used in the Monte Carlo approximation if \code{type = "mc"}.}

\item{approximation}{logical. If \code{TRUE} then \eqn{(I - \lambda W)^{-1}} is approximated as \eqn{I + \lambda W + \lambda^2 W^2 + \lambda^3 W^3 + ... +\lambda^q W^q}. The default is \code{FALSE}.}

\item{pw}{numeric. The power used for the approximation \eqn{I + \lambda W + \lambda^2 W^2 + \lambda^3 W^3 + ... +\lambda^q W^q}. The default is 5.}

\item{tol}{Argument passed to \code{mvrnorm}: tolerance (relative to largest variance) for numerical lack of positive-definiteness in the coefficient covariance matrix.}

\item{empirical}{logical. Argument passed to \code{mvrnorm} (default \code{FALSE}): if \code{TRUE}, the coefficients and their covariance matrix specify the empirical not population mean and covariance matrix}

\item{...}{further arguments. Ignored.}

\item{x}{an object of class \code{effect.bingmm}.}

\item{digits}{the number of digits.}
}
\value{
An object of class \code{effect.bingmm}.
}
\description{
Obtain the average marginal effects from \code{bingmm} or \code{binlgmm} class model.
}
\details{
Let the model be:

\deqn{
y^*= X\beta + WX\gamma + \lambda W y^* + \epsilon = Z\delta + \lambda Wy^{*} + \epsilon
}

where  \eqn{y = 1} if \eqn{y^*>0} and 0 otherwise; \eqn{\epsilon \sim N(0, 1)} if \code{link = "probit"} or \eqn{\epsilon \sim L(0, \pi^2/3)} if \code{link = "logit"}.

The marginal effects respect to variable \eqn{x_r} can be computed as

\deqn{
diag(f(a))D^{-1}_{\lambda}A^{-1}_{\lambda}\left(I_n\beta_r + W\gamma_r\right) = C_r(\theta)
}

where \eqn{f()} is the pdf, which depends on the assumption of the error terms; \eqn{diag} is the operator that creates a \eqn{n \times n} diagonal matrix; \eqn{A_{\lambda}= (I -\lambda W)}; and \eqn{D_{\lambda}} is a diagonal matrix whose elements represent the square root of the diagonal elements of the variance-covariance matrix of \eqn{u = A_{\lambda}^{-1}\epsilon}. 

We implement these three summary measures: (1) The average total effects, \eqn{ATE_r  = n^{-1}i_n'C_{r}i_n}, (2) The average direct effects, \eqn{ADE_r  = n^{-1}tr(C_{r})}, and (3) the average indirect effects, \eqn{ATE_r - ADE_r}. 

The standard errors of the average total, direct and indirect effects can be estimated using either Monte Carlo (MC) approximation, which takes into account the sampling distribution of \eqn{\theta}, or Delta Method.
}
\examples{
\donttest{
# Data set
data(oldcol, package = "spdep")

# Create dependent (dummy) variable
COL.OLD$CRIMED <- as.numeric(COL.OLD$CRIME > 35)

# Two-step (Probit) GMM estimator
ts <- sbinaryGMM(CRIMED ~ INC + HOVAL| HOVAL,
                link = "probit", 
                listw = spdep::nb2listw(COL.nb, style = "W"), 
                data = COL.OLD, 
                type = "twostep")
                
# Marginal effects using Delta Method
summary(effect.bingmm(ts, type = "delta"))

# Marginal effects using MC with 100 draws
summary(effect.bingmm(ts, type = "mc", R = 100))

# Marginal effects using efficient VC matrix
summary(effect.bingmm(ts, type = "delta", vce = "efficient"))

# Marginal effects using efficient VC matrix and ignoring the heteroskedasticity
summary(effect.bingmm(ts, type = "delta", vce = "efficient", het = FALSE))
}
}
\seealso{
\code{\link[spldv]{sbinaryGMM}}, \code{\link[spldv]{sbinaryLGMM}}.
}
\author{
Mauricio Sarrias and Gianfranco Piras.
}
