% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitted.R, R/fitted_glm.R
\name{fitted.spmodel}
\alias{fitted.spmodel}
\alias{fitted.splm}
\alias{fitted.values.splm}
\alias{fitted.spautor}
\alias{fitted.values.spautor}
\alias{fitted.spglm}
\alias{fitted.values.spglm}
\alias{fitted.spgautor}
\alias{fitted.values.spgautor}
\title{Extract model fitted values}
\usage{
\method{fitted}{splm}(object, type = "response", ...)

\method{fitted.values}{splm}(object, type = "response", ...)

\method{fitted}{spautor}(object, type = "response", ...)

\method{fitted.values}{spautor}(object, type = "response", ...)

\method{fitted}{spglm}(object, type = "response", ...)

\method{fitted.values}{spglm}(object, type = "response", ...)

\method{fitted}{spgautor}(object, type = "response", ...)

\method{fitted.values}{spgautor}(object, type = "response", ...)
}
\arguments{
\item{object}{A fitted model object from \code{\link[=splm]{splm()}}, \code{\link[=spautor]{spautor()}}, \code{\link[=spglm]{spglm()}}, or \code{\link[=spgautor]{spgautor()}}.}

\item{type}{\code{"response"} for fitted values of the response, \code{"spcov"}
for fitted values of the spatial random errors, or \code{"randcov"} for
fitted values of the random effects. The default is \code{"response"}.}

\item{...}{Other arguments. Not used (needed for generic consistency).}
}
\value{
The fitted values according to \code{type}.
}
\description{
Extract fitted values from fitted model objects. \code{fitted.values}
is an alias.
}
\details{
When \code{type} is \code{"response"}, the fitted values
for each observation are the standard fitted values \eqn{X \hat{\beta}}.
When \code{type} is \code{"spcov"} the fitted values for each observation
are (generally) the best linear unbiased predictors of the spatial dependent and spatial
independent random error. When \code{type} is \code{"randcov"}, the fitted
values for each level of each random effect are (generally) the best linear unbiased
predictors of the corresponding random effect. The fitted values for \code{type}
\code{"spcov"} and \code{"randcov"} can generally be used to check assumptions
for each component of the fitted model object (e.g., check a Gaussian assumption).
}
\examples{
spmod <- splm(z ~ water + tarp,
  data = caribou,
  spcov_type = "exponential", xcoord = x, ycoord = y
)
fitted(spmod)
fitted.values(spmod)
fitted(spmod, type = "spcov")
}
