% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fixnames.r
\name{fixnames}
\alias{fixnames}
\title{Change names to be the same for each taxon.}
\usage{
fixnames(obj, how = "shortest", namevec = NULL)
}
\arguments{
\item{obj}{An object of class occdat}

\item{how}{One of a few different methods: 
\itemize{
 \item shortest Takes the shortest name string that is likely to be the prettiest
 to display name, and replaces alll names with that one, better for maps, etc.
 \item query This method takes the names you orginally queried on (in the occdat
 object), and replaces names in the occurrence data with them.
 \item supplied If this method, supply a vector of names to replace the names with
}}

\item{namevec}{A vector of names to replace names in the occurrence data.frames
with. Only used if how="supplied"}
}
\value{
An object of class occdat.
}
\description{
That is, this function attempts to take all the names that are synonyms, for whatever
reason (e.g., some names have authorities on them), and collapses them to the same
string - making data easier to deal with for making maps, etc.
}
\examples{
\dontrun{
spp <- c('Danaus plexippus','Accipiter striatus','Pinus contorta')
dat <- occ(spp, from='gbif', gbifopts=list(hasCoordinate=TRUE), limit=50)
fixnames(dat, how="shortest")$gbif
fixnames(dat, how="query")$gbif
fixnames(dat, how="supplied", namevec = c('abc', 'def', 'ghi'))$gbif

dat <- occ(spp, from='ecoengine', limit=50)
## doesn't changes things
fixnames(dat, how="shortest")$ecoengine$data$Danaus_plexippus
## this is better
fixnames(dat, how="query")$ecoengine$data$Danaus_plexippus
## or this
fixnames(dat, how="supplied", 
   namevec = c("Danaus","Accipiter","Pinus"))$ecoengine$data$Danaus_plexippus
}
}

