% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preview.R
\name{as_preview.latex}
\alias{as_preview.latex}
\title{Preview Spork as Latex}
\usage{
\method{as_preview}{latex}(
  x,
  wide = 70,
  long = 20,
  stem = "latex_preview",
  dir = tempdir(),
  gs_cmd = getOption("gs_cmd", "mgs"),
  preamble = "\\\\usePackage{amsmath}\\\\n",
  prolog = "\\\\begin{center}",
  epilog = "\\\\end{center}",
  ...
)
}
\arguments{
\item{x}{spork; see \code{\link{as_spork}}}

\item{wide}{nominal page width}

\item{long}{nominal page length}

\item{dir}{a working directory; see \code{\link[latexpdf]{as.pdf}}}

\item{gs_cmd}{ghostscript command; see \code{\link[latexpdf]{ghostconvert}}}

\item{prolog}{passed to \code{\link[latexpdf]{as.document}}}

\item{epilog}{passed to \code{\link[latexpdf]{as.document}}}

\item{...}{passed arguments}
}
\value{
invisible filepath
}
\description{
Preview spork after conversion to latex.
Creates and displays a temporary png file, after
conversion from pdf using \code{\link[latexpdf]{ghostconvert}}.
}
\examples{
\donttest{
# library(magrittr)
# 'one joule (Omega) ~ 1 kg*m^2./s^2' \%>\%
# as_spork \%>\%
# as_latex \%>\%
#as_preview
}
}
\seealso{
Other preview: 
\code{\link{as.png.plotmath}()},
\code{\link{as.png.spork}()},
\code{\link{as_preview.plotmath}()},
\code{\link{as_previews.spork}()},
\code{\link{as_previews}()},
\code{\link{as_preview}()},
\code{\link{ggplot.plotmath}()},
\code{\link{ggplot.spork}()}
}
\concept{preview}
\keyword{internal}
