% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/handle_noise.R
\name{handle_noise}
\alias{handle_noise}
\title{Handling noise in the clustering results}
\usage{
handle_noise(global_membership, timeID, minPts, minTime)
}
\arguments{
\item{global_membership}{Integer. A vector of membership labels.}

\item{timeID}{Integer. A vector of time indexes.}

\item{minPts}{Numeric (>0). Minimum number of hot spots in a cluster.}

\item{minTime}{Numeric (>=0). Minimum length of time of a cluster.
Unit is time index.}
}
\value{
Integer. A vector of membership labels.
}
\description{
This function finds noise from the clustering results and label it with
\code{-1}.
}
\details{
For more details about the clustering algorithm and the arguments
\code{minPts} and \code{minTime}, please check the documentation
of \code{\link[=hotspot_cluster]{hotspot_cluster()}}.
This function performs the \strong{step 4} of the clustering algorithm. It uses a
given threshold (minimum number of points and minimum length of time) to
find noise and label it with \code{-1}.
}
\examples{

# Define membership labels and timeID for 10 observations
global_membership <- c(1,1,1,2,2,2,2,2,2,3,3,3,3,3,3)
timeID <- c(1,2,3,2,3,3,4,5,6,3,3,3,3,3,3)

# Handle noise with different values of minPts and minTime
handle_noise(global_membership, timeID, 4, 0)
handle_noise(global_membership, timeID, 4, 1)
handle_noise(global_membership, timeID, 3, 3)

}
