% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/label_switching.R
\name{FixLS_da}
\alias{FixLS_da}
\title{Fix Label Switching}
\usage{
FixLS_da(fit, burnin = floor(fit$L/10), xlab = "x", ylab = "y",
  approx = TRUE, plot_result = FALSE, run_silent = FALSE)
}
\arguments{
\item{fit}{Object of class \code{damcmc_res} or \code{bdmcmc_res}.}

\item{burnin}{Number of initial realizations to discard. By default, it is 1/10 of the total number of iterations.}

\item{xlab}{The label for the x-axis.}

\item{ylab}{The label for the y-axis.}

\item{approx}{Logical flag to request use of the identifiability constraint
to permute all realizations. If FALSE, minimizing
the loss function can be very slow for moderate to large
number of components (m>10), since the algorithm
goes through all \code{m!} permutations for each
posterior realization.}

\item{plot_result}{Logical flag for requesting plots of the point pattern
and intensity surface based on the permuted
realizations. The default is FALSE.}

\item{run_silent}{Logical flag to hide progress messages. Default is FALSE.}
}
\description{
Permutes the posterior realizations in order to
fix the labels by either applying
an identifiability constraint or by minimizing
the squared error loss to find the best
permutation.

For examples see

\url{http://www.stat.missouri.edu/~amicheas/sppmix/sppmix_all_examples.html
#FixLS_da}
}
\examples{

\dontrun{
# generate data
mix1 <- normmix(ps=c(.4, .2,.4), mus=list(c(0.3, 0.3), c(.5,.5),c(0.7, 0.7)),
 sigmas = list(.02*diag(2),.05*diag(2), .02*diag(2)),lambda = 100, win = spatstat::square(1))
#plot the true mixture
plot(mix1,main = "True Poisson intensity surface (mixture of normal components)")
pp1 <- rsppmix(mix1)
# Run Data augmentation MCMC and get posterior realizations
postfit = est_mix_damcmc(pp1, m=3, truncate=TRUE)
#plot the chains
plot_chains(postfit)
plot_chains(postfit,separate = FALSE)
# get the intensity of posterior means
post_mean = GetPMEst(postfit)
# plot the estimated intensity surface
plot(post_mean)
#check labels
check_labels(postfit)
# Fix label switching, start with approx=TRUE
post_fixed = FixLS_da(postfit, plot_result = TRUE)
plot_chains(post_fixed)
plot_chains(post_fixed, separate = FALSE)
#this one works better in theory
post_fixed = FixLS_da(postfit, approx=FALSE, plot_result = TRUE)
plot_chains(post_fixed)
plot_chains(post_fixed, separate = FALSE)}

}
\author{
Jiaxun Chen, Sakis Micheas
}
\references{
Jasra, A., Holmes, C.C. and
Stephens, D. A. (2005). Markov Chain Monte
Carlo Methods and the Label Switching
Problem in Bayesian Mixtures. Statistical
Science, 20, 50-67.
}
\seealso{
\code{\link{normmix}},
\code{\link{rsppmix}},
\code{\link{est_mix_damcmc}},
\code{\link{plot_chains}},
\code{\link{check_labels}}
}

