% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcmc_plots.R
\name{plot_CompDist}
\alias{plot_CompDist}
\title{Plots for the number of components}
\usage{
plot_CompDist(fit, open_new_window = FALSE)
}
\arguments{
\item{fit}{Object of class \code{bdmcmc_res}.}

\item{open_new_window}{Open new windows for the two plots.}
}
\description{
The function produces two plots: the trace plot for the number of components based on
all realizations of a BDMCMC fit, and a barplot describing the distribution
of the number of components.

For examples see

\url{http://www.stat.missouri.edu/~amicheas/sppmix/sppmix_all_examples.html
#plot_CompDist}
}
\examples{

\dontrun{
fitBD <- est_mix_bdmcmc(spatstat::redwood, m = 10)
plot_CompDist(fitBD)
CAfitBD=est_mix_bdmcmc(pp = CAQuakes2014.RichterOver3.0, m = 10)
plot_CompDist(CAfitBD)}

}
\author{
Sakis Micheas
}
\seealso{
\code{\link{est_mix_bdmcmc}}
}

