% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/markedIPPP_mix.R
\name{plot_MPP_probs}
\alias{plot_MPP_probs}
\title{Plot the mark probabilities of a marked point pattern}
\usage{
plot_MPP_probs(MPPfit, truncate = FALSE, open_new_window = FALSE)
}
\arguments{
\item{MPPfit}{Object of class \code{MIPPP_fit}.}

\item{truncate}{Logical variable indicating to discard points
if they are not within the window of observation. Default is FALSE.}

\item{open_new_window}{Open a new window for the plot.}
}
\description{
For discrete marks only, the function
displays for each location of a marked
point pattern, the probabilities of observing
each of the discrete marks at that location.

For examples see

\url{http://www.stat.missouri.edu/~amicheas/sppmix/sppmix_all_examples.html
#plot_MPP_probs}
}
\examples{

\dontrun{
newMPP=rMIPPP_cond_loc(gammas=c(.1,.2,.5))
plot(newMPP$surf,main="True IPPP intensity surface for the locations")
genMPP=newMPP$genMPP
newMPP$r
mpp_est <- est_MIPPP_cond_loc(genMPP,newMPP$r, hyper=0.2)
plot_MPP_probs(mpp_est)}

}
\author{
Sakis Micheas
}
\seealso{
\code{\link{rMIPPP_cond_loc}},
\code{\link{est_MIPPP_cond_loc}}
}

