% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normmix_plots.R
\name{plotmix_3d}
\alias{plotmix_3d}
\title{Plot the density or intensity of a
normal mixture in 3d over a fine grid}
\usage{
plotmix_3d(dens_image, title1 = "3d Surface (Density or Intensity)",
  zlims = NULL, grayscale = FALSE)
}
\arguments{
\item{dens_image}{An image as an object of class \code{\link[spatstat]{im}}.}

\item{title1}{A title for the 3d plot.}

\item{zlims}{The limits of the z axis. Defaults to [0,1.1*max(dens_image)].}

\item{grayscale}{Plot in gray scale. Default is FALSE (use colors).}
}
\description{
When a \code{normmix} object is given, this
function calculates the mixture density over
a fine grid for the given window. When an \code{intensity_surface} object
is given, the function multiplies the density with
 the surface lambda, and returns the Poisson
 mixture intensity function over the grid. Used for plotting.

For examples see

\url{http://faculty.missouri.edu/~micheasa/sppmix/sppmix_all_examples.html
#plotmix_3d}
}
\examples{
\donttest{
truemix <- rnormmix(m = 5, sig0 = .1, df = 5, xlim= c(0, 3), ylim = c(0, 3))
normdens=dnormmix(truemix, xlim= c(0, 3), ylim = c(0, 3))
plotmix_3d(normdens)
plotmix_3d(normdens, title1="Density of a normal mixture")
#use the demo_mix and demo_truemix3comp objects; the windows are found in the
#corresponding demo demo_intsurf and demo_intsurf3comp
demo_intsurf$window
normdens1=dnormmix(demo_mix, xlim= c(0, 1), ylim = c(0, 1))
plotmix_3d(normdens1, title1="Density of a normal mixture, 2 components")
#change the window
normdens1=dnormmix(demo_mix, xlim= c(-1, 1.5), ylim = c(-1, 1.5))
plotmix_3d(normdens1, title1="Density of a normal mixture, 2 components")
demo_intsurf3comp$window
normdens2=dnormmix(demo_truemix3comp, xlim= c(-1, 1), ylim = c(-2, 3))
plotmix_3d(normdens2, title1="Density of a normal mixture, 3 components")}

}
\seealso{
\code{\link{rnormmix}},
\code{\link{dnormmix}}
}
\author{
Jiaxun Chen, Sakis Micheas, Yuchen Wang
}
