% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Ibeta.R
\name{Ibeta}
\alias{Ibeta}
\title{Incomplete Beta Function}
\usage{
Ibeta(z, a, b)
}
\arguments{
\item{z}{Vector of \code{n} model parameters.}

\item{a}{Vector of \code{n} model parameters.}

\item{b}{Vector of \code{n} model parameters.}
}
\value{
Returns a vector of numerical values
}
\description{
Calculation of the incomplete beta function used in\link[spsh]{sncFun.01110}
}
\details{
If \code{a=1} or \code{a=1/n} and \code{b=0}, this implementation cannot evaluate values for \code{z < 1.014}.
}
\examples{
x = seq(.5, 4.2 , length = 20)
alf = 0.1
n = 2
y = 1 + (alf * 10^x)^n

result <- Ibeta(z = y, a = 1, b = 0 )

}
\author{
Tobias KD Weber , \email{tobias.weber@uni-hohenheim.de}
}
