\name{distogram}
\alias{distogram}
\title{ Draw a color-coded triangular distance matrix }
\description{ This figure is a color-coded, rotated triangular matrix indicating the distance between every pair of items. }
\usage{
distogram(x, map, 
  n = 10, base = NA, colFn = heat, 
  key = TRUE,  title = NA, ...)
}
\arguments{
  \item{x}{ A \code{\link{dist}} object, or a square numeric matrix. }
  \item{map}{ A color map, as generated by \code{\link{makecmap}} (optional). }
  \item{n, base, colFn}{ Arguments passed to \code{\link{makecmap}}, if \code{map} is omitted. }
  \item{key}{ Add a color key? }
  \item{title}{ Title for the color key. }
  \item{\dots}{ Further arguments passed to \code{\link{trianglegram}}, (e.g. \code{labels}). }
}
\details{ 

}
\value{ The color map, invisibly. }
\seealso{ \code{\link{corrogram}} }
\examples{ 
  ## default
  distogram(eurodist, title = 'Distance (km)')  

  ## variations
  map <- distogram(eurodist, key = FALSE, colFn = jet, right = TRUE)  
  vkey(map, title = 'Distance (km)', x = -8)

}
\keyword{ hplot }
