% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{Oncoplot}
\alias{Oncoplot}
\title{Drawing a waterfall plot of a particular pathway.}
\usage{
Oncoplot(
  maf,
  samp_class,
  sur,
  mut_status,
  pathway,
  pathway_name,
  isTCGA = FALSE,
  top = 20,
  clinicalFeatures = c("sample_group", "event"),
  class_col = c("#00468B", "#ED0000"),
  event_col = c("#B3DE69", "#BC80BD"),
  sortByAnnotation = TRUE,
  gene_mar = 7,
  removeNonMutated = FALSE,
  drawRowBar = TRUE,
  drawColBar = TRUE,
  leftBarData = NULL,
  leftBarLims = NULL,
  rightBarData = NULL,
  rightBarLims = NULL,
  topBarData = NULL,
  logColBar = FALSE,
  draw_titv = FALSE,
  showTumorSampleBarcodes = FALSE,
  fill = TRUE,
  showTitle = TRUE,
  titleText = NULL
)
}
\arguments{
\item{maf}{A data of MAF format.}

\item{samp_class}{A vector containing subtype labels of the samples.}

\item{sur}{A matrix containing the samples' survival time and survival status.}

\item{mut_status}{A binary mutations matrix.The file can be generated by the function `get_mut_status`.}

\item{pathway}{A list containing pathway information .}

\item{pathway_name}{The names of the pathways that you want to visualize.For example "JAK-STAT signaling pathway".}

\item{isTCGA}{Is input MAF file from TCGA source? If TRUE uses only first 12 characters from Tumor_Sample_Barcode.}

\item{top}{How many top genes to be drawn,genes are arranged from high to low depending on the frequency of mutations. defaults to 20.}

\item{clinicalFeatures}{Columns names from 'clinical.data' slot of MAF to be drawn in the plot.}

\item{class_col}{The color of sample class .}

\item{event_col}{The color of survival status .}

\item{sortByAnnotation}{Logical sort oncomatrix (samples) by provided 'clinicalFeatures'. Sorts based on first 'clinicalFeatures'. Defaults to TRUE. column-sort.}

\item{gene_mar}{Margin width for gene names.}

\item{removeNonMutated}{Logical. If TRUE removes samples with no mutations in the GenePathwayOncoplots for better visualization. Default FALSE.}

\item{drawRowBar}{Logical. Plots righ barplot for each gene. Default TRUE.}

\item{drawColBar}{Logical plots top barplot for each sample. Default TRUE.}

\item{leftBarData}{Data for leftside barplot. Must be a data.frame with two columns containing gene names and values. Default 'NULL'.}

\item{leftBarLims}{Limits for 'leftBarData'. Default 'NULL'.}

\item{rightBarData}{Data for rightside barplot. Must be a data.frame with two columns containing to gene names and values. Default 'NULL' which draws distibution by variant classification. This option is applicable when only 'drawRowBar' is TRUE.}

\item{rightBarLims}{Limits for 'rightBarData'. Default 'NULL'.}

\item{topBarData}{Default 'NULL' which draws absolute number of mutation load for each sample. Can be overridden by choosing one clinical indicator(Numeric) or by providing a two column data.frame contaning sample names and values for each sample. This option is applicable when only 'drawColBar' is TRUE.}

\item{logColBar}{Plot top bar plot on log10 scale. Default FALSE.}

\item{draw_titv}{Logical Includes TiTv plot. Default FALSE}

\item{showTumorSampleBarcodes}{Logical to include sample names.}

\item{fill}{Logical. If TRUE draws genes and samples as blank grids even when they are not altered.}

\item{showTitle}{Default TRUE.}

\item{titleText}{Custom title. Default 'NULL'.}
}
\value{
No return value
}
\description{
Load the data in MAF format and draw a waterfall plot.
}
\examples{
#load the data
mut_path <- system.file("extdata","maffile.txt",package = "ssMutPA")
maf<-maftools::read.maf(mut_path ,isTCGA = FALSE)
pathway_path <- system.file("extdata","kegg_323_gmt.Rdata",package = "ssMutPA")
load(pathway_path)
data(samp_class_onco,mut_onco,sur_onco)
##draw a waterfall plot
#win.graph()
Oncoplot(maf,samp_class_onco,sur_onco,mut_onco,kegg_323_gmt,"IL-17 signaling pathway")
}
