% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{get_RWR_ES}
\alias{get_RWR_ES}
\title{Calculate the single-sample mutation-based pathway enrichment score.}
\usage{
get_RWR_ES(
  mut_status,
  min_sample = 0,
  max_sample = dim(mut_status)[1],
  net_data,
  pathway_data,
  r = 0.7,
  Numcore = 2,
  BC_Num = length(V(net_data)$name),
  cut_point = 0
)
}
\arguments{
\item{mut_status}{A binary mutation matrix.The file can be generated by the function `get_mut_status`.}

\item{min_sample}{The minimum number of mutated genes contained in a sample,default to 0.}

\item{max_sample}{The maximum number of mutated genes contained in a sample.}

\item{net_data}{A list of the PPI network information, including nodes and edges.}

\item{pathway_data}{A data frame containing the pathways and their corresponding genes. The first column is the names of pathways and the second column is the genes included in the pathways.}

\item{r}{A numeric value between 0 and 1. r is a certain probability of continuing the random walk or restarting from the restart set. Default to 0.7.}

\item{Numcore}{The number of threads when running programs with multiple threads,default to 2 .}

\item{BC_Num}{Number of background genes required to calculate seed node weight.}

\item{cut_point}{The threshold of indicator function .}
}
\value{
A single-sample mutation-based pathway enrichment score profiles, where each element represents the enrichment score of a pathway in a sample.
}
\description{
The function `get_RWR_ES` is used to calculate the single-sample mutation-based pathway enrichment score. Using somatic mutation data,PPI network and pathway data.
}
\examples{
#load the data
data(mut_status)
net_path <- system.file("extdata","ppi_network.Rdata",package = "ssMutPA")
load(net_path)
pathway_path<-system.file("extdata","kegg_323_gmt.Rdata",package = "ssMutPA")
load(pathway_path)
samp_name<-c("TCGA-06-0881-01A","TCGA-76-4934-01A")
examp_data<-mut_status[,samp_name]
#perform the function `get_RWR_ES`.
\donttest{Path_ES<-get_RWR_ES(examp_data,net_data=ppi_network,pathway_data=kegg_323_gmt,BC_Num=12436)}
}
