% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{comma_signif}
\alias{comma_signif}
\title{Comma and Significance Formatter}
\usage{
comma_signif(x, digits = 3, ...)
}
\arguments{
\item{x}{A numeric vector to format.}

\item{digits}{A whole number specifying the number of significant figures}

\item{...}{Additional arguments passed to \link[scales:label_number]{scales::comma}.}
}
\value{
A character vector.
}
\description{
By default the numeric vectors are first rounded to three significant figures.
Then scales::commas is only applied to values greater than or equal to 1000
to ensure that labels are permitted to have different numbers of decimal places.
}
\examples{
comma_signif(c(0.1, 1, 10, 1000))
scales::comma(c(0.1, 1, 10, 1000))
}
