#    Copyright 2015 Province of British Columbia
#
#    Licensed under the Apache License, Version 2.0 (the "License");
#    you may not use this file except in compliance with the License.
#    You may obtain a copy of the License at
#
#       https://www.apache.org/licenses/LICENSE-2.0
#
#    Unless required by applicable law or agreed to in writing, software
#    distributed under the License is distributed on an "AS IS" BASIS,
#    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#    See the License for the specific language governing permissions and
#    limitations under the License.

test_that("ssd_plot_cdf", {
  setup(pdf(tempfile(fileext = ".pdf")))
  teardown(dev.off())
  
  expect_is(ssd_plot_cdf(boron_lnorm), "ggplot")
  expect_is(ssd_plot_cdf(boron_dists), "ggplot")
  fluazinam_lnorm$censdata$right[3] <- fluazinam_lnorm$censdata$left[3] * 1.5
  fluazinam_lnorm$censdata$left[5] <- NA
  expect_is(ssd_plot_cdf(fluazinam_lnorm), "ggplot")
  expect_is(ssd_plot_cdf(fluazinam_dists), "ggplot")
})
