% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/burrrIII3.R, R/gamma.R, R/gompertz.R,
%   R/invpareto.R, R/lgumbel.R, R/llogis-llogis.R, R/llogis.R, R/lnorm-lnorm.R,
%   R/lnorm.R, R/pqr.R, R/weibull.R
\name{ssd_rburrIII3}
\alias{ssd_rburrIII3}
\alias{ssd_rgamma}
\alias{ssd_rgompertz}
\alias{rgompertz}
\alias{ssd_rinvpareto}
\alias{ssd_rlgumbel}
\alias{rlgumbel}
\alias{ssd_rllogis_llogis}
\alias{ssd_rllogis}
\alias{ssd_rlnorm_lnorm}
\alias{ssd_rlnorm}
\alias{ssd_r}
\alias{ssd_rweibull}
\title{Random Number Generation}
\usage{
ssd_rburrIII3(n, shape1 = 1, shape2 = 1, scale = 1, chk = TRUE)

ssd_rgamma(n, shape = 1, scale = 1, chk = TRUE)

ssd_rgompertz(n, location = 1, shape = 1, chk = TRUE)

rgompertz(n, llocation = 0, lshape = 0)

ssd_rinvpareto(n, shape = 3, scale = 1, chk = TRUE)

ssd_rlgumbel(n, locationlog = 0, scalelog = 1, chk = TRUE)

rlgumbel(n, locationlog = 0, scalelog = 1)

ssd_rllogis_llogis(
  n,
  locationlog1 = 0,
  scalelog1 = 1,
  locationlog2 = 1,
  scalelog2 = 1,
  pmix = 0.5,
  chk = TRUE
)

ssd_rllogis(n, locationlog = 0, scalelog = 1, chk = TRUE)

ssd_rlnorm_lnorm(
  n,
  meanlog1 = 0,
  sdlog1 = 1,
  meanlog2 = 1,
  sdlog2 = 1,
  pmix = 0.5,
  chk = TRUE
)

ssd_rlnorm(n, meanlog = 0, sdlog = 1, chk = TRUE)

ssd_rweibull(n, shape = 1, scale = 1, chk = TRUE)
}
\arguments{
\item{n}{number of observations.}

\item{shape1}{shape1 parameter.}

\item{shape2}{shape2 parameter.}

\item{scale}{scale parameter.}

\item{chk}{A flag specifying whether to check the arguments.}

\item{shape}{A string of the column in data for the shape aesthetic.}

\item{location}{location parameter.}

\item{llocation}{location parameter on the log scale.}

\item{lshape}{shape parameter on the log scale.}

\item{locationlog}{location on log scale parameter.}

\item{scalelog}{scale on log scale parameter.}

\item{locationlog1}{locationlog1 parameter.}

\item{scalelog1}{scalelog1 parameter.}

\item{locationlog2}{locationlog2 parameter.}

\item{scalelog2}{scalelog2 parameter.}

\item{pmix}{Proportion mixture parameter.}

\item{meanlog1}{mean on log scale parameter.}

\item{sdlog1}{standard deviation on log scale parameter.}

\item{meanlog2}{mean on log scale parameter.}

\item{sdlog2}{standard deviation on log scale parameter.}

\item{meanlog}{mean on log scale parameter.}

\item{sdlog}{standard deviation on log scale parameter.}
}
\description{
Random Number Generation
}
\section{Functions}{
\itemize{
\item \code{ssd_rburrIII3()}: Random Generation for BurrIII Distribution

\item \code{ssd_rgamma()}: Random Generation for Gamma Distribution

\item \code{ssd_rgompertz()}: Random Generation for Gompertz Distribution

\item \code{rgompertz()}: Random Generation for Gompertz Distribution
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

\item \code{ssd_rinvpareto()}: Random Generation for Inverse Pareto Distribution

\item \code{ssd_rlgumbel()}: Random Generation for log-Gumbel Distribution

\item \code{rlgumbel()}: Random Generation for log-Gumbel Distribution
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

\item \code{ssd_rllogis_llogis()}: Random Generation for Log-Logistic/Log-Logistic Mixture Distribution

\item \code{ssd_rllogis()}: Random Generation for Log-Logistic Distribution

\item \code{ssd_rlnorm_lnorm()}: Random Generation for Log-Normal/Log-Normal Mixture Distribution

\item \code{ssd_rlnorm()}: Random Generation for Log-Normal Distribution

\item \code{ssd_rweibull()}: Random Generation for Weibull Distribution

}}
\examples{

set.seed(50)
hist(ssd_rburrIII3(10000), breaks = 1000)

set.seed(50)
hist(ssd_rgamma(10000), breaks = 1000)

set.seed(50)
hist(ssd_rgompertz(10000), breaks = 1000)

set.seed(50)
hist(ssd_rinvpareto(10000), breaks = 1000)

set.seed(50)
hist(ssd_rlgumbel(10000), breaks = 1000)

set.seed(50)
hist(ssd_rllogis_llogis(10000), breaks = 1000)

set.seed(50)
hist(ssd_rllogis(10000), breaks = 1000)

set.seed(50)
hist(ssd_rlnorm_lnorm(10000), breaks = 1000)

set.seed(50)
hist(ssd_rlnorm(10000), breaks = 1000)

set.seed(50)
hist(ssd_rweibull(10000), breaks = 1000)
}
\seealso{
\code{\link{ssd_p}} and \code{\link{ssd_q}}
}
