#' Creates an SST Test input page layout.
#'
#' @param ... Lists generated by \code{shiny::fluidRow} functions.
#'
#' @return A \code{shinydashboard::tabItem} containing all items passed
#' in \code{...} that can be used in a \code{shinydashboard::tabItems} function.
#'
sstTestInput.pageLayout <- function(...) {
  fluidPage(
    id = "sstTestInputs",
    fluidRow(
      column(
        width = 12,
        tags$h2("Simulation parameters", id="params")
      )
    ),
    actionButton("introJsInput", label = "Interactive help", onclick = "inputIntro()"),
    ...
  )
}

#' Creates a two box layout with spacing on the right and left side.
#'
#' @param ... Lists generated by \code{shinydashboard::box} functions.
#'
#' @return A \code{shiny::fluidRow} containing all items passed
#' in \code{...} that can be used in a \code{shinydashboard::tabItem} function.
#'
sstTestInput.inputBoxes <- function(...) {
  fluidRow(
    column(
      width = 2
    ),
    ...
  )
}

#' Creates a box to upload an excel file.
#'
#' @return A \code{shinydashboard::box} containing all items passed
#' in \code{...} that can be used in a \code{shiny::fluidRow} function.
#'
sstTestInput.excelBox <- function() {
  shinydashboard::box(
    title = "Source portfolio (.xlsx)",
    id = "excelBox",
    solidHeader = TRUE,
    status = "primary",
    width = 4,
    fileInput("excel", label = "Upload your excel portfolio...")
  )
}

#' Creates a box to set a number of simulations.
#'
#' @return A \code{shinydashboard::box} containing a \code{shiny::fileInput}
#' that can be used in a \code{shiny::fluidRow} function.
#'
sstTestInput.numSimBox <- function() {
  shinydashboard::box(
    title= "Number of simulations",
    id = "numSimBox",
    status = "primary",
    solidHeader = TRUE,
    width = 4,
    textInput("numSim", "Number of simulations", placeholder = "An integer >= 1'000"),
    div(style = "height: 25px")
  )
}

#' Creates a \code{shiny::fluidRow} containing a centered "Run Simulations"
#' button
#'
#' @return A \code{shiny::fluidRow} containing a \code{shiny::actionbutton}
#' that can be used in a \code{shiny::fluidRow} function.
#'
sstTestInput.runSimButton <- function() {
  fluidRow(
    div(
      width = 12,
      style = "text-align: center;",
      actionButton("runSim", "Run simulation")
    )
  )
}
