% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers-sstModel-computation.R
\name{expectedShortfall}
\alias{expectedShortfall}
\title{Compute the Expected Shortfall}
\usage{
expectedShortfall(x, alpha = 0.01, sup = F, ...)
}
\arguments{
\item{x}{a numeric vector. The vector from which to compute the expected shortfall.}

\item{alpha}{a numeric value. The alpha-Expected Shortfall, must take values
between 0 and 1. Please note that \code{alpha} represents the mass lying below the \code{alpha}
quantile of \code{x} in the case \code{sup = FALSE} or the mass lying above the \code{1-alpha}
quantile of \code{x} in the other case \code{sup = TRUE}}

\item{sup}{a logical value. If \code{TRUE} the function returns the upper
expected shortfall and otherwise the lower. Default is set to \code{FALSE}.}

\item{...}{additional parameters.}
}
\value{
a numeric value. The expected shortfall.
}
\description{
function to compute the alpha-Expected Shortfall of a vector.
}
\note{
Please consider that we include the boundary value into the empirical mean estimation.
}
