% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lifeRisk-base.R
\name{lifeRisk}
\alias{lifeRisk}
\title{Constructing a LifeRisk}
\usage{
lifeRisk(corr.mat, quantile)
}
\arguments{
\item{corr.mat}{matrix of numeric values. This must be a valid
correlation matrix and should have names, i.e. attributes
\code{colnames} and \code{rownames} indicating the names of the
corresponding life insurance risk-factors.}

\item{quantile}{positive numeric value smaller than one representing the probabilities
at which the life sensitivities will be interpreted as (1-\code{quantile})-quantiles.}
}
\value{
an S3 object, instance of the class lifeRisk.
}
\description{
\code{lifeRisk} is the constructor for the
  S3 class lifeRisk. It allows to build for life
  insurance risks parameters.
}
\examples{
# Creating new lifeRisks.

corr.mat <- diag(rep(1, 2))
colnames(corr.mat) <- c("invalidity", "longetivity")
rownames(corr.mat) <- colnames(corr.mat)

lifeRisk1 <- lifeRisk(corr.mat  = corr.mat,
                      quantile = c(0.995, 0.995))

}
\seealso{
\code{\link{summary.lifeRisk}}, \code{\link{print.lifeRisk}},
\code{\link{simulate.lifeRisk}}, \code{\link{compute.lifeRisk}}.
}
