% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parafac_functions.R
\name{eempf_eemqual}
\alias{eempf_eemqual}
\title{Calculating EEMqual which is an indicator of a PARAFAC model's quality}
\usage{
eempf_eemqual(pfmodel, eem_list, splithalf = NULL, ...)
}
\arguments{
\item{pfmodel}{PARAFAC model}

\item{eem_list}{EEM data as eemlist}

\item{splithalf}{optionally, you can supplie available splithalf results from model to decrease computation time}

\item{...}{additional arguments passed to splithalf}
}
\value{
data frame containing fit, corcondia, product of best TCCs from splithalf analysis, eemqual and splithalf models
}
\description{
Calculating EEMqual which is an indicator of a PARAFAC model's quality
}
\examples{
\donttest{
data(eem_list)
data(pfres_comps2)

pfmodel <- pfres_comps2[[2]]
eempf_eemqual(eem_list,pfmodel)
}
}
\references{
Rasmus Bro, Maider Vidal, EEMizer: Automated modeling of fluorescence EEM data, Chemometrics and Intelligent Laboratory Systems, Volume 106, Issue 1, 2011, Pages 86-92, ISSN 0169-7439
}
