% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correction_functions.R
\name{eem_interp}
\alias{eem_interp}
\title{Missing values are interpolated within EEM data}
\usage{
eem_interp(
  data,
  cores = parallel::detectCores(logical = FALSE),
  type = TRUE,
  verbose = FALSE,
  nonneg = TRUE,
  extend = FALSE,
  ...
)
}
\arguments{
\item{data}{object of class eemlist with spectra containing missing values}

\item{cores}{specify number of cores for parallel computation}

\item{type}{numeric 0 to 4 or TRUE which resembles type 1}

\item{verbose}{logical, whether more information on calculation should be provided}

\item{nonneg}{logical, whether negative values should be replaced by 0}

\item{extend}{logical, whether data is extrapolated using type 1}

\item{...}{arguments passed on to other functions (pchip, na.approx, mba.points)}
}
\value{
object of class eemlist with interpoleted spectra.
}
\description{
Missing EEM data can be interpolated. Usually it is the result of removing scatter or other parts where noise is presumed. Different interpolation algorithms can be used (see details).
}
\details{
The types of interpolation are (0) setting all NAs to 0, (1) spline interpolation with \code{\link[MBA]{mba.points}}, (2) excitation and emission wavelength-wise interpolation with \code{\link[pracma]{pchip}} and subsequent mean, (3) excitation wavelength-wise interpolation with \code{\link[pracma]{pchip}} and (4) linear interpolation in 2 dimensions with \code{\link[zoo]{na.approx}} and again subsequent mean calculation. Calculating the mean is a way of ensuring NAs are also interpolated where missing boundary values would make that impossible. Using type = 1, extrapolation can be suppressed by adding the argument extend = FALSE.
}
\examples{
\donttest{
data(eem_list)
eem_list <- eem_list[1:6]
class(eem_list) <- "eemlist"

remove_scatter <- c(TRUE, TRUE, TRUE, TRUE)

remove_scatter_width = c(15,10,16,12)

eem_list <- eem_rem_scat(eem_list,remove_scatter,remove_scatter_width)

eem_list <- eem_interp(eem_list)

ggeem(eem_list)

eem_list2 <- eem_setNA(eem_list,ex=200:280,interpolate=FALSE)

ggeem(eem_list2)

eem_list3 <- eem_interp(eem_list2,type=1,extend = TRUE)

ggeem(eem_list3)

eem_list3 <- eem_interp(eem_list2,type=1,extend = FALSE)

ggeem(eem_list3)


}
}
\references{
Elcoroaristizabal, S., Bro, R., García, J., Alonso, L. 2015. PARAFAC models of fluorescence data with scattering: A comparative study. Chemometrics and Intelligent Laboratory Systems, 142, 124-130
\url{https://doi.org/10.1016/j.chemolab.2015.01.017}
}
\seealso{
\code{\link[pracma]{pchip}}, \code{\link[MBA]{mba.points}}, \code{\link[zoo]{na.approx}}
}
