% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stab_par.R
\name{stab_par}
\alias{stab_par}
\alias{sta_par}
\title{Stability Parameters for Genotypes by Environment Interaction (GEI)}
\usage{
sta_par(x, rep, MSE, alpha = 0.1, Env.Cov = NULL)
}
\arguments{
\item{x}{PARAM_DESCRIPTION}

\item{rep}{No of Replicates}

\item{MSE}{Mean Square Error}

\item{alpha}{Level of Significance, default is 0.1}

\item{Env.Cov}{Environmental Covariate, default is NULL}
}
\value{
Stability Parameters
}
\description{
Stability Parameters for Genotypes by Environment Interaction (GEI)
}
\examples{

data(ge_data)
YieldANOVA <- add_anova(ge_data, Rep, Gen, Env, Yield)[[1]]
Yield.ge_means <- ge_means(data = ge_data, G = Gen, E = Env, Y = Yield)
Yield.ge_means$ge_means

Yield.StabPar <-
sta_par(
  x     = as.matrix(Yield.ge_means$ge_means)
, rep   = length(levels(ge_data$Rep))
, MSE   = YieldANOVA["Residuals", "Mean Sq"]
, alpha = 0.1
)

Yield.StabPar

}
\references{
Singh, R. K. and Chaudhary, B. D. (2004) \emph{Biometrical Methods in Quantitative Genetic Analysis}.
             New Delhi: Kalyani.
}
\author{
Muhammad Yaseen (\email{myaseen208@gmail.com})
}
