% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stab_fox.R
\name{stab_fox}
\alias{stab_fox}
\alias{stab_fox.default}
\title{Stability Fox Function}
\usage{
stab_fox(.data, .y, .rep, .gen, .env)

\method{stab_fox}{default}(.data, .y, .rep, .gen, .env)
}
\arguments{
\item{.data}{data.frame}

\item{.y}{Response Variable}

\item{.rep}{Replication Factor}

\item{.gen}{Genotypes Factor}

\item{.env}{Environment Factor}
}
\description{
Performs a stability analysis based on the criteria of
             Fox et al. (1990), using the statistical "TOP third" only.
             In Fox function, a stratified ranking of the genotypes at
             each environment separately is done. The proportion of locations
             at which the genotype occurred in the top third are expressed in
             TOP output.
}
\examples{
data(ge_data)
YieldFox <-
     stab_fox(
            .data = ge_data
          , .y    = Yield
          , .rep  = Rep
          , .gen  = Gen
          , .env  = Env
      )
YieldFox

}
\references{
\enumerate{
         \item  Fox, P.N. and Skovmand, B. and  Thompson, B.K. and  Braun, H.J. and Cormier, R. (1990). Yield and adaptation of hexaploid spring triticale. \emph{Euphytica},  \strong{47}, 57-64.
         }
}
\author{
\enumerate{
         \item Muhammad Yaseen (\email{myaseen208@gmail.com})
         \item Kent M. Edkridge (\email{keskridge1@unl.edu})
         }
}
