% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unscale.R
\name{unscale}
\alias{unscale}
\title{Reverse a scale}
\usage{
unscale(z, center = attr(z, "scaled:center"), scale = attr(z,
  "scaled:scale"))
}
\arguments{
\item{z}{a numeric matrix(like) object}

\item{center}{either NULL or a numeric vector of length 
equal to the number of columns of z}

\item{scale}{either NULL or a numeric vector of length 
equal to the number of columns of z}
}
\description{
Computes x = sz+c, which is the inverse of z = (x - c)/s 
provided by the \code{scale} function.
}
\examples{
 mtcs <- scale(mtcars)
 
 all.equal(
   unscale(mtcs), 
   as.matrix(mtcars), 
   check.attributes=FALSE
 )
 
 oldSeed <- .Random.seed
 z <- unscale(rnorm(10), 2, .5)
 .Random.seed <- oldSeed
 x <- rnorm(10, 2, .5)
 all.equal(z, x, check.attributes=FALSE)


}
\references{
\url{https://stackoverflow.com/questions/10287545/backtransform-scale-for-plotting/46840073}
}
\seealso{
\code{\link{scale}}
}
\author{
Neal Fultz
}
