require(stacomiR)
# launching stacomi without selecting the scheme or interface
stacomi(gr_interface=FALSE,
		login_window=FALSE,
		database_expected=FALSE)
# the following script will load the Arzal dataset if connected to iav schema
\dontrun{
	# overriding user schema to point to Parc Marais Poitevin 
	# (longest historical dataset available
	# in France for eel ...) this suppose you have access to the pmp schema...
	# a glimpse of the dataset is still available in the bmi dataset 
	# loaded in the package...
	baseODBC<-get("baseODBC",envir=envir_stacomi)
	baseODBC[c(2,3)]<-rep("pmp",2)
	assign("baseODBC",baseODBC,envir_stacomi)
	sch<-get("sch",envir=envir_stacomi)
	assign("sch","pmp.",envir_stacomi)
	bmi<-new("BilanMigrationInterAnnuelle")
	bmi<-choice_c(bmi,
			dc=c(16),
			taxons=c("Anguilla anguilla"),
			stades=c("AGJ"),
			anneedebut="2007",
			anneefin="2012",
			silent=TRUE)
	bmi<-connect(bmi)	
}	
# load the dataset generated by previous lines
data("bmi")
# the first plot is of little interest, it allows to see what data 
# are available... simple lines
# For irregular operations like those reported at the enfrenaux eel ladder....
plot(bmi,plot.type="line",silent=TRUE)

# a plot to show the seasonality, Here it has also to do with the monitoring period
# the y unit has little sense in this graph
plot(bmi,plot.type="density",silent=TRUE)

bmi<-calcule(bmi,timesplit="semaine")

#install.packages("viridis")
\dontrun{
	if (requireNamespace("ggplot2", quietly = TRUE)&
		requireNamespace("viridis", quietly = TRUE)){
	g<-get("g",envir=envir_stacomi)	
	g+
			ggplot2::scale_fill_manual(values=viridis::viridis(22))+
			ggplot2::ggtitle("Saisonnalite de la migration aux Enfrenaux")
}
# the standard plot is showing daily values
plot(bmi,plot.type="standard",silent=TRUE)
# Manual edition of the graph produced
if (requireNamespace("ggplot2", quietly = TRUE)){
g1<-get("g1",envir=envir_stacomi)
g1<-g1+ggplot2::ggtitle("Les Enfrenaux")+
		ggplot2::scale_fill_manual(name="Source", 
				values=c("purple","#0A0C01"),
				labels = c("historical set","2015 values"))+
		ggplot2::scale_colour_manual(name="Source", values="#B8EA00",
				labels = c("historical mean"))	+
		ggplot2::ylab("Nombre d'anguilles")
print(g1)
}

# Another graph from scratch
if (requireNamespace("ggplot2", quietly = TRUE)&
	requireNamespace("viridis", quietly = TRUE)){
dat<-funtraitementdate(bmi@data, # tableau de donnees a importer
		"bjo_jour", # nom de la colonne
		annee=FALSE,
		mois=TRUE,
		semaine =TRUE,
		jour_mois=FALSE)
# sum per month
res<-dplyr::select(dat,bjo_valeur,bjo_annee,semaine)
res<-dplyr::group_by(res,bjo_annee,semaine)
res<-dplyr::summarize(res,effectif=sum(bjo_valeur))
ggplot2::ggplot(res, ggplot2::aes(x = semaine, y = bjo_annee,fill=effectif)) +
	ggplot2::geom_tile(colour="black") + ggplot2::coord_fixed() +
	viridis::scale_fill_viridis(begin=0,option="D") + ggplot2::theme_bw()+
	ggplot2::theme(panel.background= ggplot2::element_rect(fill = "#9360A9"),
			panel.grid.major=ggplot2::element_line(colour="#C1DB39"),
			panel.grid.minor=ggplot2::element_line(colour="#7DD632"))+
	ggplot2::ylab("year")+ggplot2::xlab("week")+
	ggplot2::ggtitle("Historical trend at Les Enfrenaux Eel trap")
	
}
# available arguments for timesplit are "quinzaine" and "mois" and "semaine"
# with the silent=TRUE argument, it's always the latest year that is selected
plot(bmi,plot.type="barchart",timesplit="quinzaine",silent=TRUE)
# Comparison with historical values. Each year and 2 weeks values 
# is a point on the graph...
plot(bmi,plot.type="pointrange",timesplit="mois",silent=TRUE)

plot(bmi,plot.type="step",silent=TRUE)
if (requireNamespace("ggplot2", quietly = TRUE)&
		requireNamespace("viridis", quietly = TRUE)){
	g<-get("g",envir=envir_stacomi)	+ ggplot2::theme_minimal()
	g+viridis::scale_color_viridis(discrete=TRUE)+
			ggplot2::ggtitle("Cumulated migration step plot 
							at les Enfrenaux eel trap")
	
}

data("bmi_vichy")
bmi_vichy<-calcule(bmi_vichy,timesplit="jour",silent=TRUE)
#bmi_vichy@calcdata

bmi_vichy<-calcule(bmi_vichy,timesplit="semaine",silent=TRUE)
#bmi_vichy@calcdata

bmi_vichy<-calcule(bmi_vichy,timesplit="jour_365")
#bmi_vichy@calcdata

plot(bmi_vichy,plot.type="seasonal",timesplit="semaine",silent=TRUE)
plot(bmi_vichy,plot.type="seasonal",timesplit="mois",silent=TRUE)
plot(bmi_vichy,plot.type="seasonal",timesplit="jour",silent=TRUE)



# A test with lampreys in the Descarte DF (Vienne)
baseODBC<-get("baseODBC",envir=envir_stacomi)
baseODBC[c(2,3)]<-rep("logrami",2)
assign("baseODBC",baseODBC,envir_stacomi)
sch<-get("sch",envir=envir_stacomi)
assign("sch","logrami.",envir_stacomi)
bmi_des<-new("BilanMigrationInterAnnuelle") #descartes
bmi_des<-choice_c(bmi_des,
		dc=c(23),
		taxons=c("Petromyzon marinus"),
		stades=c("5"),
		anneedebut="2007",
		anneefin="2014",
		silent=TRUE)
bmi_des<-charge(bmi_des)
bmi_des<-connect(bmi_des)	
bmi_des<-calcule(bmi_des,timesplit="semaine")
plot(bmi_des,plot.type="seasonal",timesplit="semaine")
plot(bmi_des,plot.type="seasonal",timesplit="jour")
plot(bmi_des,plot.type="seasonal",timesplit="mois")
}	



