% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ref_stage.R
\docType{methods}
\name{charge_with_filter,ref_stage-method}
\alias{charge_with_filter,ref_stage-method}
\title{Loading method for ref_stage referential objects searching only those stages existing for a DC and a Taxon}
\usage{
\S4method{charge_with_filter}{ref_stage}(object, dc_selectionne,
  taxa_selectionne)
}
\arguments{
\item{object}{An object of class \link{ref_stage-class}}

\item{dc_selectionne}{The selected counting device}

\item{taxa_selectionne}{The selected species}
}
\value{
An S4 object of class \link{ref_stage-class}
}
\description{
Loading method for ref_stage referential objects searching only those stages existing for a DC and a Taxon
}
\examples{
\dontrun{
 dc_selectionne=6
taxa_selectionne=2038
 object=new("ref_stage")
 charge_with_filter(object,dc_selectionne,taxa_selectionne)
}
}
\author{
Cedric Briand \email{cedric.briand"at"eptb-vilaine.fr}
}

