% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report_silver_eel.R
\docType{class}
\name{report_silver_eel-class}
\alias{report_silver_eel-class}
\alias{report_silver_eel}
\title{Class "report_silver_eel"}
\description{
the report_silver_eel class is used to calculate various statistics about the silver eel run. It comprises calculation
of various maturation index such as Durif's stages and Pankhurst eye index. The objective is to provide standardized
output to the stations monitoring the silver eel run.
}
\section{Slots}{

\describe{
\item{\code{data}}{A data frame with data generated from the database}

\item{\code{calcdata}}{A list of dc with processed data. Each dc contains a data frame with
\itemize{
\item (1) qualitative data on body contrast (CONT), presence of punctuation on the lateral line (LINP)
\item (2) quantitative data "BL" Body length,"W" weight,"Dv" vertical eye diameter,"Dh" horizontal eye diameter,"FL" pectoral fin length
\item (3) calculated durif stages, Pankhurst's index, Fulton's body weight coefficient K_ful
\item (4) other columns containing data pertaining to the sample and the control operation:  lot_identifiant,ope_identifiant,
ope_dic_identifiant,ope_date_debut,ope_date_fin,dev_code (destination code of fish),
dev_libelle (text for destination of fish)
}}

\item{\code{dc}}{Object of class \link{ref_dc-class}: the control devices}

\item{\code{taxa}}{An object of class \link{ref_taxa-class}: the species}

\item{\code{stage}}{An object of class \link{ref_stage-class} : the stages of the fish}

\item{\code{par}}{An object of class \link{ref_par-class}: the parameters used}

\item{\code{horodatedebut}}{An object of class \link{ref_horodate-class}}

\item{\code{horodatefin}}{An object of class \link{ref_horodate-class}}
}}

\note{
This class is displayed by interface_report_silver_eel
}
\section{Objects from the Class}{
 Objects can be created by calls of the form
\code{new("report_silver_eel", ...)}
}

\examples{
# launching stacomi without selecting the scheme or interface
stacomi(	database_expected=FALSE)
# the following script will load data from the two Anguillere monitored in the Somme

# If you have a working database
# the following line of code will create the r_silver dataset 
# from the "fd80." schema in the database
\dontrun{
	stacomi(database_expected=TRUE, sch="fd80.")	# overrides the default option sch = 'iav'
	# prompt for user and password, you can set these in the options, 
	# including dbname and host
	if (interactive()){
		if (!exists("user")){
			user <- readline(prompt="Enter user: ")
			password <- readline(prompt="Enter password: ")	
		}	
	}
	options(					
			stacomiR.dbname = "bd_contmig_nat",
			stacomiR.host ="localhost",
			stacomiR.port = "5432",
			stacomiR.user = user,
			stacomiR.user = password						
	)	
	
  #create an instance of the class
  r_silver<-new("report_silver_eel")
  r_silver<-choice_c(r_silver,
	  dc=c(2,6),			
	  horodatedebut="2010-09-01",
	  horodatefin="2016-10-04",
	  silent=FALSE)
  r_silver<-connect(r_silver)	
}	
# load the dataset generated by previous lines
data("r_silver")
# the calculation will fill the slot calcdata
r_silver<-calcule(r_silver)
# stages are in r_silver@calcdata[["6"]][,"stage"] 
#look at data structure using str(r_silver@calcdata[["6"]])

# standard plot as drawn by Laurent Beaulaton (Analyse des donnees d'argenture acquises en France)
# showing Durif's stage according to size and eye diameter
plot(r_silver, plot.type=1)

# number per month or year and Durif's stage (year if number of dc >1)
plot(r_silver, plot.type="2")

# plot showing fulton's coefficient, and size weight graphs
# inspired from Acou et al., 2009 
# Differential Production and Condition Indices of Premigrant
# Eels in Two Small Atlantic Coastal Catchments
# of France
plot(r_silver, plot.type="3")
# get a list of summary data and print output to screen

plot(r_silver, plot.type="4")
# print a summary statistic, and save the output in a list for later use
stats<-summary(r_silver)
}
\seealso{
Other report Objects: 
\code{\link{report_annual-class}},
\code{\link{report_dc-class}},
\code{\link{report_df-class}},
\code{\link{report_env-class}},
\code{\link{report_ge_weight-class}},
\code{\link{report_mig-class}},
\code{\link{report_mig_char-class}},
\code{\link{report_mig_env-class}},
\code{\link{report_mig_interannual-class}},
\code{\link{report_mig_mult-class}},
\code{\link{report_sample_char-class}},
\code{\link{report_sea_age-class}},
\code{\link{report_species-class}}
}
\author{
Cedric Briand \email{cedric.briand"at"eptb-vilaine.fr}
}
\concept{report Objects}
\keyword{classes}
