% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1b-base-model-function.R
\name{compare.sevt}
\alias{compare.sevt}
\alias{hamming.sevt}
\alias{stagesdiff.sevt}
\title{Compare two staged event tree}
\usage{
compare.sevt(
  object1,
  object2,
  method = "naive",
  return.tree = FALSE,
  plot = FALSE,
  ...
)

hamming.sevt(object1, object2, return.tree = FALSE)

stagesdiff.sevt(object1, object2)
}
\arguments{
\item{object1}{a staged event tree}

\item{object2}{a staged event tree}

\item{method}{method to compare staged event trees. It can be: \code{"naive"}, \code{"hamming"} or \code{"stages"}}

\item{return.tree}{logical, if \code{TRUE} the difference tree is returned}

\item{plot}{logical}

\item{...}{additional parameters to be passed to \code{\link{plot.sevt}}}
}
\value{
if \code{return.tree = FALSE}, logical: \code{TRUE} if the two
models are exactly equal, otherwise \code{FALSE}.
Else If \code{return.tree = TRUE}  it returns the differences between
the two trees, according to the selected \code{method}.
}
\description{
Compare two stages event tree, return the differences of the stages
structure and plot the difference tree. Three different methods to
compute the difference tree are available.
}
\details{
\code{compare.sevt} tests if the stage structure of two \code{sevt}
objects
is the same.
Three methods are available:
\itemize{
\item \code{naive} first applies \code{\link{stndnaming.sevt}} to both
objects and then simply compares the resulting stages lists
(\code{stages.sevt(object1)} and \code{stages.sevt(object2)}).
\item \code{hamming} uses the \code{hamming.sevt} function that try to map
stages in the different objects finding the few number of nodes that
must be changed to obtain the same structure.
\item \code{stages} uses the \code{stagesdiff.sevt} function that compare
stages to check if the same stage structure is present in both models.
}

Setting \code{return.tree = TRUE} will return the stages
structure difference obtained with the selected method.

With \code{plot = TRUE} the plot of the difference tree is obtained.

If \code{return.tree = FALSE} the logical output is the same for the
three methods and thus the \code{naive} method should be used
since it is computationally faster.

To use the \code{hamming} method, the package \code{clue}
must be installed.

Functions \code{\link{hamming.sevt}} and \code{\link{stagesdiff.sevt}}
can also be used directly.
}
\examples{
data("PhDArticles")
mod1 <- bhc.sevt(full(PhDArticles[, 1:4], lambda = 1))
mod2 <- fbhc.sevt(full(PhDArticles[, 1:4], lambda = 1))
compare.sevt(mod1, mod2)

##########
m0 <- full(PhDArticles[, 1:4], fit = TRUE, lambda = 0)
m1 <- bhc.sevt(m0)
m2 <- bj.sevt(m0, distance = tv, thr = 0.25)
stagesdiff.sevt(m1, m2)
}
