% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spinkit-dependencies.R, R/spinkit-handler.R
\name{useSpinkit}
\alias{useSpinkit}
\alias{spinkit}
\title{SpinKit}
\usage{
useSpinkit()

spinkit(uiOutput, type = "plane", color = "#333", size = "40px")
}
\arguments{
\item{uiOutput}{An output element to be wrapped within a spinner.}

\item{type}{Type of spinner to use. Valid values are:
\itemize{
\item plane
\item chase
\item bounce
\item wave
\item pulse
\item flow
\item swing
\item circle
\item circle_fade
\item grid
\item fold
\item wander
}}

\item{color}{Color of the spinner. Defaults to \code{"#333"}. Choose between hexadecimal, RGB or keyword values.}

\item{size}{Size of the spinner. Defaults to \code{"40px"}.}
}
\value{
None
}
\description{
Simple CSS spinners.
}
\section{Functions}{

\itemize{
\item \code{useSpinkit}: Dependencies to include in your UI.
\item \code{spinkit}: Display loading animation.
}
}

\examples{
if (interactive()) {
  library(shiny)

  shinyApp(
    ui = fluidPage(
      useSpinkit(),
      actionButton("render", "Render"),
      spinkit(plotOutput("plot"))
    ),
    server = function(input, output) {
      output$plot <- renderPlot({
        input$render
        Sys.sleep(3)
        hist(mtcars$mpg)
      })
    }
  )
}

}
