% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tingle-dependencies.R, R/tingle-handler.R
\name{useTingle}
\alias{useTingle}
\alias{tingle}
\title{Tingle}
\usage{
useTingle()

tingle(
  content = "Hello",
  close_button = FALSE,
  button_label = "Close",
  button_type = "default",
  button_position = "right",
  session = getDefaultReactiveDomain()
)
}
\arguments{
\item{content}{Content of the modal.}

\item{close_button}{Logical; if \code{TRUE}, displays a button to close the modal. Defaults to \code{FALSE}.}

\item{button_label}{Label of \code{close_button}.}

\item{button_type}{Type of button. Defaults to \code{"default"}. Other valid values are:
\itemize{
\item \code{"primary"}
\item \code{"danger"}
}}

\item{button_position}{Position of the button inside the modal. Defaults to \code{"right"}. Valid values are:
\itemize{
\item \code{"right"}
\item \code{"left"}
}}

\item{session}{Shiny session object.}
}
\value{
None
}
\description{
Minimalist and easy to use modals.
}
\section{Functions}{

\itemize{
\item \code{useTingle}: Dependencies to include in your UI.
\item \code{tingle}: Display modals.
}
}

\examples{
if (interactive()) {
library(shiny)
library(standby)

ui <- fluidPage(

  useTingle(), # include dependencies
  actionButton(inputId = "btn",
               label   = "Tingle Demo")

)

server <- function(input, output, session) {

  observeEvent(input$btn, {
    # display modal
    tingle("Hey there!, Thank you for exploring standby!")
  })
}

shinyApp(ui, server)
}

}
