% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/split_pdf.R
\name{split_pdf}
\alias{split_pdf}
\title{Splits single input PDF document into individual pages.}
\usage{
split_pdf(input_filepath = NULL, output_directory = NULL, prefix = "page_")
}
\arguments{
\item{input_filepath}{the path of the input PDF file. The default is set to
NULL. IF NULL, it  prompt the user to select the folder interactively.}

\item{output_directory}{the path of the output directory}

\item{prefix}{A string for output filename prefix}
}
\value{
this function splits a single input PDF document into
individual pages
}
\description{
If the toolkit Pdftk is available in the
system, it will be called to Split a single input PDF document
into individual pages.

See the reference for detailed usage of \code{pdftk}.
}
\examples{
\dontrun{
split_pdf()
}

\dontrun{
dir <- tempdir()
require(lattice)
for(i in 1:3) {
pdf(file.path(dir, paste("plot", i, ".pdf", sep = "")))
print(xyplot(iris[,1] ~ iris[,i], data = iris))
dev.off()
}
staple_pdf(input_directory = dir, output_filepath = file.path(dir, 'Full_pdf.pdf'))
split_pdf(input_filepath = file.path(dir, paste("Full_pdf.pdf",  sep = "")),output_directory = dir )
}
}
\references{
\url{https://www.pdflabs.com/tools/pdftk-the-pdf-toolkit/}
}
\author{
Priyanga Dilini Talagala and Ogan Mancarci
}
