% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subset.R
\name{stars_subset}
\alias{stars_subset}
\alias{[.stars}
\alias{[<-.stars}
\alias{st_flip}
\title{subset stars objects}
\usage{
\method{[}{stars}(x, i = TRUE, ..., drop = FALSE, crop = !is_curvilinear(x))

\method{[}{stars}(x, i) <- value

st_flip(x, which = 1)
}
\arguments{
\item{x}{object of class \code{stars}}

\item{i}{first selector: integer, logical or character vector indicating attributes to select, or object of class \code{sf} or \code{sfc} used as spatial selector; see details}

\item{...}{further (logical or integer vector) selectors, matched by order, to select on individual dimensions}

\item{drop}{logical; if \code{TRUE}, degenerate dimensions (with only one value) are dropped}

\item{crop}{logical; if \code{TRUE} and parameter \code{i} is a spatial geometry (\code{sf} or \code{sfc}) object, the extent (bounding box) of the result is cropped to match the extent of \code{i} using \link{st_crop}. Cropping curvilinear grids is not supported.}

\item{value}{array of dimensions equal to those in \code{x}, or a vector or value that will be recycled to such an array}

\item{which}{character or integer; dimension(s) to be flipped}
}
\value{
\code{st_flip} flips (reverts) the array values along the chosen dimension 
without(s) changing the dimension properties
}
\description{
subset stars objects
}
\details{
if \code{i} is an object of class \code{sf}, \code{sfc} or \code{bbox}, the spatial subset covering this geometry is selected, possibly followed by cropping the extent. Array values for which the cell centre is not inside the geometry are assigned \code{NA}.

in an assignment (or replacement form, \code{[<-}), argument \code{i} needs to be a \code{stars} object with dimensions identical to \code{x}, and \code{value} will be recycled to the dimensions of the arrays in \code{x}.
}
\examples{
tif = system.file("tif/L7_ETMs.tif", package = "stars")
x = read_stars(tif)
x[,,,1:3] # select bands
x[,1:100,100:200,] # select x and y by range
x["L7_ETMs.tif"] # select attribute
xy = structure(list(x = c(293253.999046018, 296400.196497684), y = c(9113801.64775462,
9111328.49619133)), .Names = c("x", "y"))
pts = st_as_sf(data.frame(do.call(cbind, xy)), coords = c("x", "y"), crs = st_crs(x))
image(x, axes = TRUE)
plot(st_as_sfc(st_bbox(pts)), col = NA, add = TRUE)
bb = st_bbox(pts)
(xx = x[bb])
image(xx)
plot(st_as_sfc(bb), add = TRUE, col = NA)
image(x)
pt = st_point(c(x = 290462.103109179, y = 9114202.32594085))
buf = st_buffer(st_sfc(pt, crs = st_crs(x)), 1500)
plot(buf, add = TRUE)

buf = st_sfc(st_polygon(list(st_buffer(pt, 1500)[[1]], st_buffer(pt, 1000)[[1]])),
   crs = st_crs(x))
image(x[buf])
plot(buf, add = TRUE, col = NA)
image(x[buf, crop=FALSE])
plot(buf, add = TRUE, col = NA)
}
