% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract.R
\name{st_extract}
\alias{st_extract}
\alias{st_extract.stars}
\title{Extract cell values at point locations}
\usage{
st_extract(x, ...)

\method{st_extract}{stars}(
  x,
  at,
  ...,
  bilinear = FALSE,
  time_column = attr(at, "time_column") \%||\% attr(at, "time_col"),
  interpolate_time = bilinear,
  FUN = mean
)
}
\arguments{
\item{x}{object of class \code{stars} or \code{stars_proxy}}

\item{...}{passed on to \link{aggregate.stars} when geometries are not exclusively POINT geometries}

\item{at}{object of class \code{sf} or \code{sfc} with geometries, or two-column matrix with points in rows, indicating where to extract x}

\item{bilinear}{logical; use bilinear interpolation rather than nearest neighbour?}

\item{time_column}{character or integer; name or index of a column with time or date values that will be matched to values of the dimension "time" in \code{x}, after which this dimension is reduced. This is useful to extract data cube values along a trajectory; see https://github.com/r-spatial/stars/issues/352 .}

\item{interpolate_time}{logical; should time be interpolated? if FALSE, time instances are matched using the coinciding or the last preceding time in the data cube.}

\item{FUN}{function used to aggregate pixel values when geometries of \code{at} intersect with more than one pixel}
}
\value{
if \code{at} is of class \code{matrix}, a matrix with extracted values is returned; 
otherwise: if \code{x} has more dimensions than only x and y (raster), an 
object of class \code{stars} with POINT geometries replacing x and y raster
dimensions, if this is not the case, an object of \code{sf} with extracted values.
}
\description{
Extract cell values at point locations
}
\details{
points outside the raster are returned as \code{NA} values. For
large sets of points for which extraction is needed, passing a matrix as
to \code{at} may be much faster than passing an \code{sf} or \code{sfc} object.
}
\examples{
tif = system.file("tif/L7_ETMs.tif", package = "stars")
r = read_stars(tif)
pnt = st_sample(st_as_sfc(st_bbox(r)), 10)
st_extract(r, pnt)
st_extract(r, pnt) \%>\% st_as_sf()
st_extract(r[,,,1], pnt)
st_extract(r, st_coordinates(pnt)) # "at" is a matrix: return a matrix
}
