% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/star_schema_incremental_refresh.R
\name{incremental_refresh_star_schema}
\alias{incremental_refresh_star_schema}
\alias{incremental_refresh_star_schema.star_schema}
\title{Incrementally refresh a star schema with another}
\usage{
incremental_refresh_star_schema(st, st_new, existing = "ignore")

\method{incremental_refresh_star_schema}{star_schema}(st, st_new, existing = "ignore")
}
\arguments{
\item{st}{A \code{star_schema} object.}

\item{st_new}{A \code{star_schema} object.}

\item{existing}{A string, operation to be performed with records in the fact
table whose keys match.}
}
\value{
A \code{star_schema} object.
}
\description{
Incrementally refresh a star schema with the content of a new one that is
integrated into the first.
}
\details{
Once the dimensions are integrated, if there are records in the fact table
whose keys match the new ones, new ones can be ignored, they can be replaced
by new ones, all of them can be grouped using the aggregation functions, or
they can be deleted. Therefore, the possible values of the \code{existing}
parameter are: "ignore", "replace", "group" or "delete".
}
\examples{
library(tidyr)

st <- st_mrs_age \%>\%
  incremental_refresh_star_schema(st_mrs_age_w10, existing = "replace")

st <- st_mrs_cause \%>\%
  incremental_refresh_star_schema(st_mrs_cause_w10, existing = "group")

}
\seealso{


Other incremental refresh functions: 
\code{\link{incremental_refresh_constellation}()}
}
\concept{incremental refresh functions}
\keyword{internal}
