% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{dm_mrs_cause}
\alias{dm_mrs_cause}
\title{Star Definition for Mortality Reporting System by Cause}
\format{
A \code{dimensional_model} object.
}
\usage{
dm_mrs_cause
}
\description{
Definition of facts and dimensions for the Mortality Reporting System
considering the cause classification.
}
\examples{
# Defined by:

library(tidyr)

dm_mrs_cause <- dimensional_model() \%>\%
  define_fact(
    name = "mrs_cause",
    measures = c(
      "Pneumonia and Influenza Deaths",
      "Other Deaths"
    ),
  ) \%>\%
  define_dimension(
    name = "when",
    attributes = c(
      "Week Ending Date",
      "WEEK",
      "Year"
    )
  ) \%>\%
  define_dimension(
    name = "when_received",
    attributes = c(
      "Reception Date",
      "Reception Week",
      "Reception Year"
    )
  ) \%>\%
  define_dimension(
    name = "when_available",
    attributes = c(
      "Data Availability Date",
      "Data Availability Week",
      "Data Availability Year"
    )
  ) \%>\%
  define_dimension(
    name = "where",
    attributes = c(
      "REGION",
      "State",
      "City"
    )
  )

}
\keyword{datasets}
