% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/starticles.R
\docType{package}
\name{starticles}
\alias{starticles}
\title{A Generic, Publisher-Independent Template for Writing Scientific Documents in 'rmarkdown'}
\description{
A Generic, Publisher-Independent Template for Writing Scientific Documents in
'rmarkdown'
}
\details{
This package provides a 'rmarkdown' template for authoring scientific documents
that is publisher independent. Though the template can be used by itself
for many types of scientific documents and likely for submitting publications
to many journals, it is primarily intended as a starter format for writing a
scientific publication before one has chosen a specific target journal.
Once an article has been written, the format can be quickly adapted for use
with the \link[rticles:oup_article]{rticles} package. See the package vignette
for more details.

\tabular{ll}{ Package: \tab starticles\cr Type: \tab Package\cr Version:
\tab 0.1\cr Date: \tab 2022-06-07\cr License: \tab GPL (>= 3)\cr }
}
\examples{
# Use a temporary directory ----------------------------
owd = getwd()
td = tempfile()
dir.create(td,recursive=TRUE)
setwd(td)
print(td) # To see where files will be

# Create the draft template ----------------------------
rmarkdown::draft("MYARTICLENAME.Rmd","generic_article","starticles",edit=FALSE)

# Render PDF document ----------------------------------
# Fails for me when run using RStudio "Run examples" link in help,
# but not when sourced from command line.

# Requires recent version of pandoc (provided by RStudio)
if (rmarkdown::pandoc_available(version="2.17"))
  rmarkdown::render("MYARTICLENAME/MYARTICLENAME.Rmd",
                    envir=new.env(parent = globalenv()))

# Return to orignal workind directory ------------------
setwd(owd)
}
\seealso{
\code{browseVignettes("starticles")}, \link[rmarkdown:rmarkdown-package]{rmarkdown}, \link[rticles:oup_article]{rticles}
}
\author{
David M. Kaplan \email{dmkaplan2000@gmail.com}
}
\keyword{package}
