% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rcov.R
\name{rcov}
\alias{rcov}
\title{Realized Covariance}
\usage{
rcov(
  data,
  freq = c("daily", "monthly", "quarterly", "yearly"),
  make.ret = TRUE,
  cholesky = FALSE
)
}
\arguments{
\item{data}{a \code{(T x N)} \code{xts} object containing the \code{N} price/return series over period \code{T}}

\item{freq}{a string defining the desired frequency for the Realized Covariance matrices between "daily", "monthly", "quarterly" or "yearly"}

\item{make.ret}{boolean, in case it is \code{TRUE} the data are converted in returns, \code{FALSE} otherwise}

\item{cholesky}{boolean, in case it is \code{TRUE} the Cholesky factors of the Realized Covariance matrices are calculated, \code{FALSE} by default}
}
\value{
\item{Realized Covariances}{a \eqn{M \times N(N+1)/2} matrix of realized covariances, where \emph{M} is the number of lower frequency data}
\item{Cholesky Factors (optional)}{a \eqn{M \times N(N+1)/2} matrix of Cholesky factors of the realized
covariance matrices, where \emph{M} is the number of lower frequency data}
\item{returns (optional)}{a \eqn{T \times N} matrix of returns, when \code{make.ret = TRUE}}
}
\description{
Function returns the vectorization of the lowest triangular of the Realized Covariance matrices for different frequencies.
}
\examples{
data(Sample5minutes)
rc <- rcov(Sample5minutes, freq = 'daily', cholesky = TRUE, make.ret = TRUE)
print(rc)

}
\references{
Andersen T.G., Bollerslev T., Diebold F.X. and Labys P. (2003), Modeling and Forecasting Realized Volatility. \emph{Econometrica}. 71: 579-625

Barndorff-Nielsen O.E. and Shephard  N. (2002), Econometric analysis of realised volatility and its use in estimating stochastic volatility models \emph{Journal of the Royal Statistical Society}. 64(2): 253-280
}
\author{
Andrea Bucci
}
\keyword{RCOV}
