% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph.mult.scaling.R
\name{graph.mult.scaling}
\alias{graph.mult.scaling}
\title{Multidimensional Scaling of Graphs}
\usage{
graph.mult.scaling(
  Graphs,
  plot = TRUE,
  type = "n",
  dist = "JS",
  main = "",
  ...
)
}
\arguments{
\item{Graphs}{a list of undirected graphs.
If each graph has the  attribute \code{eigenvalues} containing its
eigenvalues , such values will be used to
compute their spectral density.}

\item{plot}{logical. If \code{TRUE} (default) the points chosen to represent the
Jensen-Shannon divergence between graphs are plotted.}

\item{type}{what type of plot should be drawn. The default value is \code{"n"},
which indicates that the points will not be plotted (i. e. only the labels
of the graphs will be plotted).}

\item{dist}{string indicating if you want to use the "JS" (default), "L1" or "L2"
distances. "JS" means Jensen-Shannon divergence.}

\item{main}{title of the plot (default value is "").}

\item{...}{additional parameters for \code{\link{graph.spectral.density}}.}
}
\value{
A list with class "statGraph" containing the following components:
\item{\code{method:}}{ a string indicating the used method.}
\item{\code{info:}}{ a string showing details about the method.}
\item{\code{data.name:}}{ a string with the data's name(s).}
\item{\code{values:}}{ a matrix in which each column corresponds to a coordinate and each
row corresponds to a graph (point). Then, each row gives the coordinates of
the points chosen to represent the Jensen-Shannon divergence (by default), L1, or
L2 distance between graphs.}
}
\description{
\code{graph.mult.scaling} performs multidimensional scaling of graphs. It
takes the Jensen-Shannon divergence between graphs (JS) and uses the
\code{cmdscale} function from the \code{stats} package to obtain a set of points such
that the distances between the points are similar to JS.
}
\examples{
set.seed(1)
G <- list()
for (i in 1:5) {
  G[[i]] <- igraph::sample_gnp(50, 0.5)
}
for (i in 6:10) {
  G[[i]] <- igraph::sample_smallworld(1, 50, 8, 0.2)
}
for (i in 11:15) {
  G[[i]] <- igraph::sample_pa(50, power = 1, directed = FALSE)
}
graph.mult.scaling(G)

}
\references{
Takahashi, D. Y., Sato, J. R., Ferreira, C. E. and Fujita A. (2012)
Discriminating Different Classes of Biological Networks by Analyzing the
Graph Spectra  Distribution. _PLoS ONE_, *7*, e49949.
doi:10.1371/journal.pone.0049949.

Silverman, B. W. (1986) _Density Estimation_.  London: Chapman and Hall.

Sturges, H. A. The Choice of a Class Interval. _J. Am. Statist. Assoc._,
*21*, 65-66.

Sheather, S. J. and Jones, M. C. (1991). A reliable data-based bandwidth
selection method for kernel density estimation.
_Journal of the Royal Statistical Society series B_, 53, 683-690.
http://www.jstor.org/stable/2345597.
}
\keyword{multidimensional_scaling}
