/*
 * Decompiled with CFR 0.152.
 */
package beagleutil;

import beagleutil.BasicIntInterval;
import beagleutil.IntInterval;
import beagleutil.IntIntervalTree;
import blbutil.Const;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;

public class CenteredIntIntervalTree<E extends IntInterval & Comparable<E>>
implements IntIntervalTree<E> {
    private final int start;
    private final int end;
    private int size;
    private Node<E> root;

    public CenteredIntIntervalTree(int n, int n2) {
        if (n2 < n) {
            String string = "end= " + n2 + " start=" + n;
            throw new IllegalArgumentException(string);
        }
        int n3 = n2 - n + 1;
        int n4 = n + n3 / 2;
        this.start = n;
        this.end = n2;
        this.size = 0;
        this.root = new Node(n4);
    }

    @Override
    public int start() {
        return this.start;
    }

    @Override
    public int end() {
        return this.end;
    }

    @Override
    public void clear() {
        this.clear(this.root);
        this.size = 0;
    }

    private void clear(Node<E> node) {
        if (node == null) {
            return;
        }
        node.clear();
        this.clear(((Node)node).leftChild);
        this.clear(((Node)node).rightChild);
    }

    @Override
    public boolean add(E e) {
        if (e.start() < this.start || e.end() > this.end) {
            String string = "element out of range [" + this.start + ", " + this.end + ") : " + e;
            throw new IllegalArgumentException(string);
        }
        boolean bl = this.add(this.root, e);
        if (bl) {
            ++this.size;
        }
        return bl;
    }

    private boolean add(Node<E> node, E e) {
        if (e.end() < ((Node)node).center) {
            if (((Node)node).leftChild == null) {
                int n = this.nextOffset(node);
                ((Node)node).leftChild = new Node(((Node)node).center - n);
                ((Node)node).leftChild.parent = (Node)node;
            }
            return this.add(((Node)node).leftChild, e);
        }
        if (e.start() > ((Node)node).center) {
            if (((Node)node).rightChild == null) {
                int n = this.nextOffset(node);
                ((Node)node).rightChild = new Node(((Node)node).center + n);
                ((Node)node).rightChild.parent = (Node)node;
            }
            return this.add(((Node)node).rightChild, e);
        }
        return node.add(e);
    }

    private int nextOffset(Node<E> node) {
        int n = ((Node)node).parent == null ? (this.end - this.start + 1) / 2 : Math.abs(((Node)node).center - ((Node)node).parent.center);
        assert (n > 0);
        int n2 = (n + 1) / 2;
        return n2;
    }

    @Override
    public boolean contains(E e) {
        return this.contains(this.root, e);
    }

    private boolean contains(Node<E> node, E e) {
        if (node == null) {
            return false;
        }
        if (e.end() < ((Node)node).center) {
            return this.contains(((Node)node).leftChild, e);
        }
        if (e.start() > ((Node)node).center) {
            return this.contains(((Node)node).rightChild, e);
        }
        return node.contains(e);
    }

    @Override
    public boolean remove(E e) {
        boolean bl = this.remove(this.root, e);
        if (bl) {
            --this.size;
        }
        return bl;
    }

    private boolean remove(Node<E> node, E e) {
        if (node == null) {
            return false;
        }
        if (e.end() < ((Node)node).center) {
            return this.remove(((Node)node).leftChild, e);
        }
        if (e.start() > ((Node)node).center) {
            return this.remove(((Node)node).rightChild, e);
        }
        return node.remove(e);
    }

    @Override
    public void intersect(int n, Collection<E> collection) {
        this.intersect(this.root, n, collection);
    }

    private void intersect(Node<E> node, int n, Collection<E> collection) {
        if (node == null) {
            return;
        }
        node.intersect(n, collection);
        if (n < ((Node)node).center) {
            this.intersect(((Node)node).leftChild, n, collection);
        } else if (n > ((Node)node).center) {
            this.intersect(((Node)node).rightChild, n, collection);
        }
    }

    @Override
    public void intersectPart(int n, int n2, Collection<E> collection) {
        this.intersectPart(this.root, n, n2, collection);
    }

    private void intersectPart(Node<E> node, int n, int n2, Collection<E> collection) {
        if (node == null) {
            return;
        }
        node.intersectPart(n, n2, collection);
        if (n < ((Node)node).center) {
            this.intersectPart(((Node)node).leftChild, n, n2, collection);
        }
        if (n2 > ((Node)node).center) {
            this.intersectPart(((Node)node).rightChild, n, n2, collection);
        }
    }

    @Override
    public void intersectAll(int n, int n2, Collection<E> collection) {
        this.intersectAll(this.root, n, n2, collection);
    }

    private void intersectAll(Node<E> node, int n, int n2, Collection<E> collection) {
        if (node == null) {
            return;
        }
        node.intersectAll(n, n2, collection);
        if (n2 < ((Node)node).center) {
            this.intersectAll(((Node)node).leftChild, n, n2, collection);
        }
        if (n > ((Node)node).center) {
            this.intersectAll(((Node)node).rightChild, n, n2, collection);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public E[] toArray() {
        ArrayList arrayList = new ArrayList(this.size);
        this.toArray(this.root, arrayList);
        return (IntInterval[])arrayList.toArray();
    }

    private void toArray(Node<E> node, List<E> list) {
        if (node == null) {
            return;
        }
        this.toArray(((Node)node).leftChild, list);
        list.addAll(((Node)node).sortedStart);
        this.toArray(((Node)node).rightChild, list);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[ CenteredIntIntervalTree: ");
        stringBuilder.append(Const.nl);
        stringBuilder.append("start=");
        stringBuilder.append(this.start);
        stringBuilder.append(" end=");
        stringBuilder.append(this.end);
        stringBuilder.append(" size=");
        stringBuilder.append(this.size);
        stringBuilder.append(Const.nl);
        this.toString(this.root, stringBuilder);
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    private void toString(Node<E> node, StringBuilder stringBuilder) {
        if (node == null) {
            return;
        }
        this.toString(((Node)node).leftChild, stringBuilder);
        stringBuilder.append(node);
        this.toString(((Node)node).rightChild, stringBuilder);
    }

    private static void main1(String[] stringArray) {
        int n;
        int n2;
        BasicIntInterval basicIntInterval;
        int n3;
        int n4 = 16;
        CenteredIntIntervalTree centeredIntIntervalTree = new CenteredIntIntervalTree(0, n4);
        assert (centeredIntIntervalTree.start() == 0);
        assert (centeredIntIntervalTree.end() == n4);
        assert (centeredIntIntervalTree.isEmpty());
        assert (centeredIntIntervalTree.isEmpty());
        for (n3 = 0; n3 < n4; ++n3) {
            basicIntInterval = new BasicIntInterval(n3, n3 + 1);
            assert (!centeredIntIntervalTree.contains(basicIntInterval));
            n2 = centeredIntIntervalTree.add(basicIntInterval);
            assert (n2 == 1);
            assert (centeredIntIntervalTree.contains(basicIntInterval));
            n2 = centeredIntIntervalTree.add(basicIntInterval);
            assert (n2 == 0);
        }
        assert (centeredIntIntervalTree.size() == n4);
        System.out.println("Initial Tree: " + Arrays.toString(centeredIntIntervalTree.toArray()));
        for (n3 = 0; n3 < n4; n3 += 2) {
            basicIntInterval = new BasicIntInterval(n3, n3 + 1);
            assert (centeredIntIntervalTree.contains(basicIntInterval));
            n2 = centeredIntIntervalTree.remove(basicIntInterval);
            assert (n2 == 1);
            assert (!centeredIntIntervalTree.contains(basicIntInterval));
            n2 = centeredIntIntervalTree.remove(basicIntInterval);
            assert (n2 == 0);
        }
        assert (centeredIntIntervalTree.size() == n4 / 2);
        System.out.println("Pruned Tree: " + Arrays.toString(centeredIntIntervalTree.toArray()));
        ArrayList arrayList = new ArrayList(n4);
        for (n = 0; n < n4; ++n) {
            centeredIntIntervalTree.intersect(n, arrayList);
            System.out.println("point=" + n + ": " + arrayList);
            arrayList.clear();
        }
        n = 3;
        for (n2 = 0; n2 < n4; ++n2) {
            centeredIntIntervalTree.intersectPart(n2, n2 + n, arrayList);
            System.out.println("start=" + n2 + " end=" + (n2 + n) + ": " + arrayList);
            arrayList.clear();
        }
        for (n2 = 0; n2 < n4; ++n2) {
            centeredIntIntervalTree.intersectAll(n2, n2, arrayList);
            System.out.println("start=" + n2 + " end=" + n2 + ": " + arrayList);
            arrayList.clear();
        }
        centeredIntIntervalTree.clear();
        assert (centeredIntIntervalTree.isEmpty());
        System.out.println("Empty Tree: " + Arrays.toString(centeredIntIntervalTree.toArray()));
    }

    private static void main2(String[] stringArray) {
        int n;
        int n2;
        BasicIntInterval basicIntInterval;
        int n3;
        int n4 = 16;
        int n5 = 4;
        CenteredIntIntervalTree centeredIntIntervalTree = new CenteredIntIntervalTree(-n4, n4);
        assert (centeredIntIntervalTree.start() == -n4);
        assert (centeredIntIntervalTree.end() == n4);
        assert (centeredIntIntervalTree.isEmpty());
        assert (centeredIntIntervalTree.isEmpty());
        for (n3 = 1; n3 <= n5; ++n3) {
            basicIntInterval = new BasicIntInterval(-n3 - n4 / 2, -n3);
            assert (!centeredIntIntervalTree.contains(basicIntInterval));
            n2 = centeredIntIntervalTree.add(basicIntInterval);
            assert (n2 == 1);
            assert (centeredIntIntervalTree.contains(basicIntInterval));
            n2 = centeredIntIntervalTree.add(basicIntInterval);
            assert (n2 == 0);
        }
        assert (centeredIntIntervalTree.size() == n5);
        for (n3 = 1; n3 <= n5; ++n3) {
            basicIntInterval = new BasicIntInterval(n3, n3 + n4 / 2);
            assert (!centeredIntIntervalTree.contains(basicIntInterval));
            n2 = centeredIntIntervalTree.add(basicIntInterval);
            assert (n2 == 1);
            assert (centeredIntIntervalTree.contains(basicIntInterval));
            n2 = centeredIntIntervalTree.add(basicIntInterval);
            assert (n2 == 0);
        }
        assert (centeredIntIntervalTree.size() == 2 * n5);
        System.out.println(Arrays.toString(centeredIntIntervalTree.toArray()));
        System.out.println(centeredIntIntervalTree);
        for (n3 = 1; n3 <= n5; n3 += 2) {
            basicIntInterval = new BasicIntInterval(-n3 - n4 / 2, -n3);
            assert (centeredIntIntervalTree.contains(basicIntInterval));
            n2 = centeredIntIntervalTree.remove(basicIntInterval);
            assert (n2 == 1);
            assert (!centeredIntIntervalTree.contains(basicIntInterval));
            n2 = centeredIntIntervalTree.remove(basicIntInterval);
            assert (n2 == 0);
        }
        for (n3 = 1; n3 <= n5; n3 += 2) {
            basicIntInterval = new BasicIntInterval(n3, n3 + n4 / 2);
            assert (centeredIntIntervalTree.contains(basicIntInterval));
            n2 = centeredIntIntervalTree.remove(basicIntInterval);
            assert (n2 == 1);
            assert (!centeredIntIntervalTree.contains(basicIntInterval));
            n2 = centeredIntIntervalTree.remove(basicIntInterval) ? 1 : 0;
            assert (n2 == 0);
        }
        assert (centeredIntIntervalTree.size() == n5);
        System.out.println(Arrays.toString(centeredIntIntervalTree.toArray()));
        ArrayList arrayList = new ArrayList(n4);
        for (n = -n4; n < n4; ++n) {
            centeredIntIntervalTree.intersect(n, arrayList);
            System.out.println("point=" + n + ": " + arrayList);
            arrayList.clear();
        }
        n = 3;
        for (n2 = -n4; n2 < n4; ++n2) {
            centeredIntIntervalTree.intersectPart(n2, n2 + n, arrayList);
            System.out.println("start=" + n2 + " end=" + (n2 + n) + ": " + arrayList);
            arrayList.clear();
        }
        centeredIntIntervalTree.clear();
        assert (centeredIntIntervalTree.isEmpty());
        System.out.println(Arrays.toString(centeredIntIntervalTree.toArray()));
    }

    private static final class Node<E extends IntInterval & Comparable<E>> {
        private final int center;
        private final SortedSet<E> sortedStart;
        private final SortedSet<E> sortedEnd;
        private Node<E> parent;
        private Node<E> leftChild;
        private Node<E> rightChild;

        private static <E extends IntInterval & Comparable<E>> Comparator<E> startComparator() {
            return (intInterval, intInterval2) -> {
                int n;
                int n2 = intInterval.start();
                if (n2 == (n = intInterval2.start())) {
                    return ((Comparable)((Object)intInterval)).compareTo(intInterval2);
                }
                return n2 < n ? -1 : 1;
            };
        }

        private static <E extends IntInterval & Comparable<E>> Comparator<E> endComparator() {
            return (intInterval, intInterval2) -> {
                int n;
                int n2 = intInterval.end();
                if (n2 == (n = intInterval2.end())) {
                    return ((Comparable)((Object)intInterval)).compareTo(intInterval2);
                }
                return n2 > n ? -1 : 1;
            };
        }

        Node(int n) {
            this.center = n;
            Comparator<E> comparator = Node.startComparator();
            Comparator<E> comparator2 = Node.endComparator();
            this.sortedStart = new TreeSet<E>(comparator);
            this.sortedEnd = new TreeSet<E>(comparator2);
            this.leftChild = null;
            this.rightChild = null;
        }

        boolean add(E e) {
            if (e.start() > this.center || e.end() < this.center) {
                String string = "element does not overlap center=" + this.center + ": " + e;
                throw new IllegalArgumentException(string);
            }
            boolean bl = this.sortedStart.add(e);
            boolean bl2 = this.sortedEnd.add(e);
            assert (bl == bl2);
            return bl;
        }

        boolean contains(E e) {
            boolean bl = this.sortedStart.contains(e);
            assert (bl == this.sortedEnd.contains(e));
            return bl;
        }

        boolean remove(E e) {
            boolean bl = this.sortedStart.remove(e);
            boolean bl2 = this.sortedEnd.remove(e);
            assert (bl == bl2);
            return bl;
        }

        void intersect(int n, Collection<E> collection) {
            if (n <= this.center) {
                boolean bl = false;
                Iterator iterator = this.sortedStart.iterator();
                while (iterator.hasNext() && !bl) {
                    IntInterval intInterval = (IntInterval)iterator.next();
                    if (intInterval.start() <= n) {
                        collection.add(intInterval);
                        continue;
                    }
                    bl = true;
                }
            } else {
                boolean bl = false;
                Iterator iterator = this.sortedEnd.iterator();
                while (iterator.hasNext() && !bl) {
                    IntInterval intInterval = (IntInterval)iterator.next();
                    if (intInterval.end() >= n) {
                        collection.add(intInterval);
                        continue;
                    }
                    bl = true;
                }
            }
        }

        void intersectPart(int n, int n2, Collection<E> collection) {
            if (n2 < this.center) {
                boolean bl = false;
                Iterator iterator = this.sortedStart.iterator();
                while (iterator.hasNext() && !bl) {
                    IntInterval intInterval = (IntInterval)iterator.next();
                    if (intInterval.start() <= n2) {
                        collection.add(intInterval);
                        continue;
                    }
                    bl = true;
                }
            } else if (n > this.center) {
                boolean bl = false;
                Iterator iterator = this.sortedEnd.iterator();
                while (iterator.hasNext() && !bl) {
                    IntInterval intInterval = (IntInterval)iterator.next();
                    if (n <= intInterval.end()) {
                        collection.add(intInterval);
                        continue;
                    }
                    bl = true;
                }
            } else {
                collection.addAll(this.sortedStart);
            }
        }

        void intersectAll(int n, int n2, Collection<E> collection) {
            boolean bl = false;
            Iterator iterator = this.sortedStart.iterator();
            while (iterator.hasNext() && !bl) {
                IntInterval intInterval = (IntInterval)iterator.next();
                if (intInterval.start() <= n) {
                    if (intInterval.end() < n2) continue;
                    collection.add(intInterval);
                    continue;
                }
                bl = true;
            }
        }

        void clear() {
            this.sortedStart.clear();
            this.sortedEnd.clear();
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(Const.nl);
            stringBuilder.append("[ CenteredIntIntervalTree.Node:");
            stringBuilder.append(Const.nl);
            stringBuilder.append("center=");
            stringBuilder.append(this.center);
            stringBuilder.append(" parent.center=");
            stringBuilder.append(this.parent != null ? Integer.valueOf(this.parent.center) : null);
            stringBuilder.append(" leftchild.center=");
            stringBuilder.append(this.leftChild != null ? Integer.valueOf(this.leftChild.center) : null);
            stringBuilder.append(" rightchild.center=");
            stringBuilder.append(this.rightChild != null ? Integer.valueOf(this.rightChild.center) : null);
            stringBuilder.append(Const.nl);
            stringBuilder.append("sortedStart: ");
            stringBuilder.append(this.sortedStart);
            stringBuilder.append(Const.nl);
            stringBuilder.append("sortedEnd: ");
            stringBuilder.append(this.sortedEnd);
            stringBuilder.append(Const.nl);
            stringBuilder.append(']');
            return stringBuilder.toString();
        }
    }
}

