/*
 * Decompiled with CFR 0.152.
 */
package vcf;

import beagleutil.ChromIds;
import blbutil.Const;
import blbutil.StringUtil;
import blbutil.Utilities;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import vcf.Marker;

public class BasicMarker
implements Marker {
    private static final int MIN_NUMBER_FIELDS = 8;
    private static final String[] EMPTY_ID_ARRAY = new String[0];
    private static final Map<String, String[]> allelesMap = new HashMap<String, String[]>(24);
    private final int chromIndex;
    private final int pos;
    private final String[] ids;
    private final String[] alleles;
    private final int nGenotypes;
    private final int end;

    public BasicMarker(int n, int n2, String[] stringArray, String[] stringArray2) {
        this(n, n2, stringArray, stringArray2, -1);
    }

    public BasicMarker(int n, int n2, String[] stringArray, String[] stringArray2, int n3) {
        if (n < 0 || n >= ChromIds.instance().size()) {
            throw new IndexOutOfBoundsException(String.valueOf(n));
        }
        BasicMarker.checkIds(n, n2, stringArray);
        BasicMarker.checkAlleles(n, n2, stringArray2);
        BasicMarker.checkEnd(n, n2, n3);
        this.chromIndex = n;
        this.pos = n2;
        this.ids = stringArray.length == 0 ? EMPTY_ID_ARRAY : (String[])stringArray.clone();
        this.alleles = BasicMarker.canonicalAlleles((String[])stringArray2.clone());
        this.nGenotypes = stringArray2.length * (stringArray2.length + 1) / 2;
        this.end = n3;
    }

    private static void checkIds(int n, int n2, String[] stringArray) {
        for (String string : stringArray) {
            int n3 = string.length();
            for (int i = 0; i < n3; ++i) {
                if (!Character.isWhitespace(string.charAt(i))) continue;
                String string2 = "ERROR: ID field contains white-space at " + BasicMarker.coordinate(n, n2) + " [" + string + "]";
                Utilities.exit(string2);
            }
        }
    }

    private static void checkAlleles(int n, int n2, String[] stringArray) {
        if (stringArray.length < 2) {
            String string = "ERROR: missing REF or ALT allele at " + BasicMarker.coordinate(n, n2);
            throw new IllegalArgumentException(string);
        }
        HashSet<String> hashSet = new HashSet<String>(Arrays.asList(stringArray));
        if (hashSet.size() != stringArray.length) {
            String string = "ERROR: duplicate allele at " + BasicMarker.coordinate(n, n2) + " " + Arrays.toString(stringArray);
            Utilities.exit(string);
        }
        BasicMarker.checkREF(n, n2, stringArray[0]);
        for (int i = 1; i < stringArray.length; ++i) {
            BasicMarker.checkAltAllele(n, n2, stringArray[i]);
        }
    }

    private static void checkREF(int n, int n2, String string) {
        if (string.isEmpty()) {
            String string2 = "ERROR: missing REF field at " + BasicMarker.coordinate(n, n2);
            Utilities.exit(string2);
        }
        int n3 = string.length();
        for (int i = 0; i < n3; ++i) {
            char c = Character.toUpperCase(string.charAt(i));
            if (c == 'A' || c == 'C' || c == 'G' || c == 'T' || c == 'N') continue;
            String string3 = "ERROR: REF field is not a sequence of A, C, T, G, or N characters at " + BasicMarker.coordinate(n, n2) + " [" + string + "]";
            Utilities.exit(string3);
        }
    }

    private static void checkAltAllele(int n, int n2, String string) {
        int n3 = string.length();
        if (n3 == 1 && string.charAt(0) == '*') {
            return;
        }
        if (n3 >= 2 && string.charAt(0) == '<' && string.charAt(n3 - 1) == '>') {
            for (int i = 1; i < n3 - 1; ++i) {
                char c = string.charAt(i);
                if (!Character.isWhitespace(c) && c != ',' && c != '<' && c != '>') continue;
                String string2 = "ERROR: invalid ALT allele at " + BasicMarker.coordinate(n, n2) + " [" + string + "]";
                Utilities.exit(string2);
            }
        } else {
            for (int i = 0; i < n3; ++i) {
                char c = Character.toUpperCase(string.charAt(i));
                if (c == 'A' || c == 'C' || c == 'G' || c == 'T' || c == 'N') continue;
                String string3 = "ERROR: invalid ALT allele at " + BasicMarker.coordinate(n, n2) + " [" + string + "]";
                Utilities.exit(string3);
            }
        }
    }

    private static String[] canonicalAlleles(String[] stringArray) {
        if (BasicMarker.isSNV(stringArray)) {
            String string = stringArray[0];
            for (int i = 1; i < stringArray.length; ++i) {
                string = string + stringArray[i];
            }
            String[] stringArray2 = allelesMap.get(string);
            if (stringArray2 != null) {
                stringArray = stringArray2;
            } else {
                allelesMap.put(string, (String[])stringArray.clone());
            }
        }
        return stringArray;
    }

    private static boolean isSNV(String[] stringArray) {
        for (String string : stringArray) {
            if (string.length() == 1) continue;
            return false;
        }
        return true;
    }

    private static void checkEnd(int n, int n2, int n3) {
        if (n3 != -1 && n3 < n2) {
            String string = "ERROR: invalid INFO:END field at " + BasicMarker.coordinate(n, n2) + " [" + n3 + "]";
            Utilities.exit(string);
        }
    }

    public BasicMarker(String string) {
        String[] stringArray = StringUtil.getFields(string, '\t', 9);
        if (stringArray.length < 8) {
            String string2 = "VCF record does not contain at least 8 tab-delimited fields: " + string;
            Utilities.exit(string2);
        }
        for (int i = 0; i < 5; ++i) {
            stringArray[i] = new String(stringArray[i]);
        }
        this.chromIndex = BasicMarker.extractChrom(stringArray[0], string);
        this.pos = BasicMarker.extractPos(stringArray[1], string);
        this.ids = BasicMarker.extractIds(this.chromIndex, this.pos, stringArray[2]);
        this.alleles = BasicMarker.extractAlleles(this.chromIndex, this.pos, stringArray[3], stringArray[4]);
        this.nGenotypes = this.alleles.length * (this.alleles.length + 1) / 2;
        this.end = BasicMarker.extractEnd(this.chromIndex, this.pos, string);
    }

    private static int extractChrom(String string, String string2) {
        if (string.isEmpty() || string.equals(".")) {
            String string3 = "ERROR: missing CHROM field: " + Const.nl + string2.substring(0, 80);
            Utilities.exit(string3);
        }
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c != ':' && !Character.isWhitespace(c)) continue;
            String string4 = "invalid character in CHROM field ['" + c + "']: " + Const.nl + string2.substring(0, 80);
            Utilities.exit(string4);
        }
        return ChromIds.instance().getIndex(string);
    }

    private static int extractPos(String string, String string2) {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            if (Character.isDigit(string.charAt(i))) continue;
            String string3 = "ERROR: invalid POS field [" + string + "]: " + Const.nl + string2.substring(0, 80);
            Utilities.exit(string3);
        }
        return Integer.parseInt(string);
    }

    private static String[] extractIds(int n, int n2, String string) {
        String[] stringArray;
        if (string.isEmpty()) {
            stringArray = "ERROR: missing ID field at " + BasicMarker.coordinate(n, n2);
            Utilities.exit((String)stringArray);
        }
        if (string.equals(".")) {
            return EMPTY_ID_ARRAY;
        }
        stringArray = StringUtil.getFields(string, ';');
        BasicMarker.checkIds(n, n2, stringArray);
        return stringArray;
    }

    private static String[] extractAlleles(int n, int n2, String string, String string2) {
        Object object;
        if (string.isEmpty()) {
            object = "ERROR: missing REF field at " + BasicMarker.coordinate(n, n2);
            Utilities.exit((String)object);
        }
        if (string2.isEmpty()) {
            object = "ERROR: missing ALT field: at " + BasicMarker.coordinate(n, n2);
            Utilities.exit((String)object);
        }
        object = EMPTY_ID_ARRAY;
        if (!string2.equals(".")) {
            object = StringUtil.getFields(string2, ',');
        }
        String[] stringArray = new String[((String[])object).length + 1];
        stringArray[0] = string;
        System.arraycopy(object, 0, stringArray, 1, ((String[])object).length);
        BasicMarker.checkAlleles(n, n2, stringArray);
        return BasicMarker.canonicalAlleles(stringArray);
    }

    private static int extractEnd(int n, int n2, String string) {
        String[] stringArray = StringUtil.getFields(string, ';');
        String string2 = "END=";
        int n3 = -1;
        for (String string3 : stringArray) {
            if (!string3.startsWith(string2)) continue;
            String string4 = string3.substring(4);
            int n4 = string4.length();
            for (int i = 0; i < n4; ++i) {
                char c = string4.charAt(i);
                if (Character.isDigit(c)) continue;
                String string5 = "ERROR: invalid INFO:END field at " + BasicMarker.coordinate(n, n2) + " [" + string2 + string4 + "]";
                Utilities.exit(string5);
            }
            n3 = Integer.parseInt(string4);
            BasicMarker.checkEnd(n, n2, n3);
        }
        return n3;
    }

    public static Marker flipStrand(Marker marker) {
        return new BasicMarker(marker);
    }

    private BasicMarker(Marker marker) {
        int n;
        Marker marker2 = marker;
        this.chromIndex = marker2.chromIndex();
        this.pos = marker2.pos();
        this.ids = new String[marker2.nIds()];
        for (n = 0; n < this.ids.length; ++n) {
            this.ids[n] = marker2.id(n);
        }
        this.alleles = new String[marker2.nAlleles()];
        for (n = 0; n < this.alleles.length; ++n) {
            this.alleles[n] = marker2.allele(n).charAt(0) != '<' ? BasicMarker.flipAllele(marker2.allele(n)) : marker2.allele(n);
        }
        this.nGenotypes = marker2.nGenotypes();
        this.end = marker2.end();
    }

    private static String flipAllele(String string) {
        char[] cArray = new char[string.length()];
        for (int i = 0; i < cArray.length; ++i) {
            cArray[i] = BasicMarker.flipBase(string.charAt(i));
        }
        return new String(cArray);
    }

    private static char flipBase(char c) {
        switch (c) {
            case 'A': {
                return 'T';
            }
            case 'C': {
                return 'G';
            }
            case 'G': {
                return 'C';
            }
            case 'T': {
                return 'A';
            }
            case 'N': {
                return 'N';
            }
            case '*': {
                return '*';
            }
        }
        assert (false);
        return '\u0000';
    }

    @Override
    public String chrom() {
        return ChromIds.instance().id(this.chromIndex);
    }

    @Override
    public int chromIndex() {
        return this.chromIndex;
    }

    @Override
    public int pos() {
        return this.pos;
    }

    @Override
    public int nIds() {
        return this.ids.length;
    }

    @Override
    public String id(int n) {
        return this.ids[n];
    }

    @Override
    public String id() {
        return this.ids.length > 0 ? this.ids[0] : BasicMarker.coordinate(this.chromIndex, this.pos);
    }

    @Override
    public int nAlleles() {
        return this.alleles.length;
    }

    @Override
    public String allele(int n) {
        return this.alleles[n];
    }

    @Override
    public String[] alleles() {
        return (String[])this.alleles.clone();
    }

    @Override
    public int nGenotypes() {
        return this.nGenotypes;
    }

    @Override
    public int end() {
        return this.end;
    }

    @Override
    public String toString() {
        int n;
        StringBuilder stringBuilder = new StringBuilder(50);
        stringBuilder.append(this.chrom());
        stringBuilder.append('\t');
        stringBuilder.append(this.pos);
        if (this.ids.length == 0) {
            stringBuilder.append('\t');
            stringBuilder.append('.');
        } else {
            for (n = 0; n < this.ids.length; ++n) {
                stringBuilder.append(n == 0 ? (char)'\t' : ';');
                stringBuilder.append(this.ids[n]);
            }
        }
        if (this.alleles.length == 1) {
            stringBuilder.append('\t');
            stringBuilder.append(this.alleles[0]);
            stringBuilder.append('\t');
            stringBuilder.append('.');
        } else {
            for (n = 0; n < this.alleles.length; ++n) {
                stringBuilder.append(n < 2 ? (char)'\t' : ',');
                stringBuilder.append(this.alleles[n]);
            }
        }
        return stringBuilder.toString();
    }

    @Override
    public int hashCode() {
        int n = 5;
        n = 29 * n + this.chromIndex;
        n = 29 * n + this.pos;
        for (int i = 0; i < this.alleles.length; ++i) {
            n = 29 * n + this.alleles[i].hashCode();
        }
        n = 29 * n + this.end;
        return n;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        BasicMarker basicMarker = (BasicMarker)object;
        if (this.chromIndex != basicMarker.chromIndex) {
            return false;
        }
        if (this.pos != basicMarker.pos) {
            return false;
        }
        if (!Arrays.equals(this.alleles, basicMarker.alleles)) {
            return false;
        }
        return this.end == basicMarker.end;
    }

    @Override
    public int compareTo(Marker marker) {
        if (this.chromIndex != marker.chromIndex()) {
            return this.chromIndex < marker.chromIndex() ? -1 : 1;
        }
        if (this.pos != marker.pos()) {
            return this.pos < marker.pos() ? -1 : 1;
        }
        int n = Math.min(this.alleles.length, marker.nAlleles());
        for (int i = 0; i < n; ++i) {
            int n2 = this.alleles[i].compareTo(marker.allele(i));
            if (n2 == 0) continue;
            return n2;
        }
        if (this.alleles.length != marker.nAlleles()) {
            return this.alleles.length < marker.nAlleles() ? -1 : 1;
        }
        if (this.end != marker.end()) {
            return this.end < marker.end() ? -1 : 1;
        }
        return 0;
    }

    private static String coordinate(int n, int n2) {
        return ChromIds.instance().id(n) + ':' + n2;
    }
}

