/*
 * Decompiled with CFR 0.152.
 */
package main;

import beagleutil.Samples;
import main.GenotypeValues;
import vcf.Marker;
import vcf.Markers;

public class RevGenotypeValues
implements GenotypeValues {
    private final GenotypeValues gv;

    public RevGenotypeValues(GenotypeValues genotypeValues) {
        this.gv = genotypeValues;
    }

    @Override
    public float value(int n, int n2, int n3) {
        int n4 = this.gv.nMarkers() - 1 - n;
        return this.gv.value(n4, n2, n3);
    }

    @Override
    public void add(int n, double[] dArray) {
        if (dArray.length != this.gv.markers().sumGenotypes()) {
            throw new IllegalArgumentException("values.length=" + dArray.length);
        }
        int n2 = 0;
        int n3 = this.gv.nMarkers();
        for (int i = 0; i < n3; ++i) {
            int n4 = this.gv.nMarkers() - 1 - i;
            int n5 = this.gv.marker(n4).nGenotypes();
            for (int j = 0; j < n5; ++j) {
                this.gv.add(n4, n, j, dArray[n2++]);
            }
        }
    }

    @Override
    public void add(int n, int n2, int n3, double d) {
        int n4 = this.gv.nMarkers() - 1 - n;
        this.gv.add(n4, n2, n3, d);
    }

    @Override
    public Samples samples() {
        return this.gv.samples();
    }

    @Override
    public int nSamples() {
        return this.gv.nSamples();
    }

    @Override
    public Marker marker(int n) {
        return this.gv.markers().reverse().marker(n);
    }

    @Override
    public Markers markers() {
        return this.gv.markers().reverse();
    }

    @Override
    public int nMarkers() {
        return this.gv.nMarkers();
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(100);
        stringBuilder.append('[');
        stringBuilder.append(this.getClass().toString());
        stringBuilder.append(']');
        return stringBuilder.toString();
    }
}

