/*
 * Decompiled with CFR 0.152.
 */
package net.sf.samtools.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import net.sf.samtools.Defaults;

public class IOUtil {
    @Deprecated
    public static final int STANDARD_BUFFER_SIZE = Defaults.BUFFER_SIZE;
    public static final long ONE_GB = 0x40000000L;
    public static final long TWO_GBS = 0x80000000L;
    public static final long FIVE_GBS = 0x140000000L;

    public static BufferedInputStream toBufferedStream(InputStream inputStream) {
        if (inputStream instanceof BufferedInputStream) {
            return (BufferedInputStream)inputStream;
        }
        return new BufferedInputStream(inputStream, STANDARD_BUFFER_SIZE);
    }

    public static void deleteFiles(File ... fileArray) {
        for (File file : fileArray) {
            if (file.delete()) continue;
            System.err.println("Could not delete file " + file);
        }
    }

    public static void deleteFiles(Iterable<File> iterable) {
        for (File file : iterable) {
            if (file.delete()) continue;
            System.err.println("Could not delete file " + file);
        }
    }

    public static boolean isRegularPath(File file) {
        return !file.exists() || file.isFile();
    }

    public static File newTempFile(String string, String string2, File[] fileArray, long l) throws IOException {
        File file = null;
        for (int i = 0; i < fileArray.length; ++i) {
            if (fileArray[i].getUsableSpace() <= l && i != fileArray.length - 1) continue;
            file = File.createTempFile(string, string2, fileArray[i]);
            file.deleteOnExit();
            break;
        }
        return file;
    }

    public static File newTempFile(String string, String string2, File[] fileArray) throws IOException {
        return IOUtil.newTempFile(string, string2, fileArray, 0x140000000L);
    }

    public static File getDefaultTmpDir() {
        String string = System.getProperty("user.name");
        String string2 = System.getProperty("java.io.tmpdir");
        if (string2.endsWith("/" + string)) {
            return new File(string2);
        }
        return new File(string2, string);
    }
}

