% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createFW.R
\name{FW}
\alias{FW}
\alias{createFW}
\title{S3 class FW}
\usage{
createFW(
  estimates,
  anova,
  envEffs,
  trait,
  nGeno,
  nEnv,
  TD,
  fittedGeno,
  tol,
  iter
)
}
\arguments{
\item{estimates}{A data.frame containing the estimated values.}

\item{anova}{A data.frame containing anova scores of the FW analysis.}

\item{envEffs}{A data.frame containing the environmental effects.}

\item{trait}{A character value indicating the analysed trait.}

\item{nGeno}{A numerical value containing the number of genotypes in the
analysis.}

\item{nEnv}{A numerical value containing the number of environments in the
analysis.}

\item{TD}{The object of class \code{\link[statgenSTA]{TD}} on which the
analysis was performed.}

\item{fittedGeno}{The fitted values for the genotypes.}

\item{tol}{A numerical value containing the tolerance used during the
analysis.}

\item{iter}{A numerical value containing the number of iterations for the
analysis to converge.}
}
\description{
Function for creating objects of S3 class FW (Finlay-Wilkinson).\cr
\code{\link{print}}, \code{\link{summary}}, \code{\link{plot}} and
\code{\link{report}} methods are available.
}
\seealso{
\code{\link{plot.FW}}, \code{\link{report.FW}}
}
\keyword{internal}
